% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is-seqFormat.R
\name{is_seqFormat}
\alias{is_seqFormat}
\title{Test \code{AptName} Format}
\usage{
is_seqFormat(x)
}
\arguments{
\item{x}{The object to be tested.}
}
\value{
A logical indicating whether \code{x} contains \code{AptNames} consistent
with the new format, beginning with a \code{seq.} prefix.
}
\description{
Test whether an object is in the new \code{seq.XXXX.XX} format.
}
\examples{
# character S3 method
is_seqFormat(names(example_data))   # no; meta data not ^seq.
is_seqFormat(tail(names(example_data), -20L))   # yes

# soma_adat S3 method
is_seqFormat(example_data)
}
\author{
Stu Field, Eduardo Tabacman
}
