% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivotExpressionSet.R, R/z-deprecated.R
\name{pivotExpressionSet}
\alias{pivotExpressionSet}
\alias{meltExpressionSet}
\title{Convert to Long Format}
\usage{
pivotExpressionSet(eSet)

meltExpressionSet(eSet)
}
\arguments{
\item{eSet}{An \code{ExpressionSet} class object, created using \code{\link[=adat2eSet]{adat2eSet()}}.}
}
\value{
A \code{tibble} consisting of the long format
conversion of an \code{ExpressionSet} object.
}
\description{
Utility to convert an \code{ExpressionSet} class object
from the "wide" data format to the "long" format via \code{\link[=pivot_longer]{pivot_longer()}}.
The \pkg{Biobase} package is required for this function.
}
\section{Functions}{
\itemize{
\item \code{meltExpressionSet()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}. Please now use \code{\link[=pivotExpressionSet]{pivotExpressionSet()}}.

}}
\examples{
# subset into a reduced mini-ADAT object
# 10 samples (rows)
# 5 clinical variables and 3 features (cols)
sub_adat <- example_data[1:10, c(1:5, 35:37)]
ex_set   <- adat2eSet(sub_adat)

# convert ExpressionSet object to long format
adat_long <- pivotExpressionSet(ex_set)
}
\seealso{
Other eSet: 
\code{\link{adat2eSet}()}
}
\author{
Stu Field
}
\concept{eSet}
