% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{C_input_crops_LUT}
\alias{C_input_crops_LUT}
\title{Look-up-table with default values to calculate carbon (C) inputs by crops}
\format{
A tibble with 28 rows and 19 columns:
\describe{
  \item{Crop}{Name of the crop}
  \item{RP}{Ratio of the C in the product to the total carbon that is allocated by the plant (in a year)}
  \item{RS}{Ratio of the C in the above ground residues (e.g. straw) to the total carbon that is allocated by the plant (in a year)}
  \item{RR}{Ratio of the C in the plant roots to the total carbon that is allocated by the plant (in a year)}
  \item{RE}{Ratio of the C in the root exudates to the total carbon that is allocated by the plant (in a year)}
  \item{SP}{Proportion of the C in the Product that is transfered to the soil}
  \item{SS}{Proportion of the C in the above ground residues (e.g. straw) that is transfered to the soil}
  \item{SR}{Proportion of the C in the roots that is transfered to the soil}
  \item{SE}{Proportion of the C in root exudates that is transfered to the soil}
  \item{crop_product}{Reference yield, derived from the Swiss fertilizer recommendations (GRUD, 2017, Chapters 8 and 9) [tDM/ha]}
  \item{harvest_index}{Ratio of the product to the total of the product and the above ground residues. Calculated by RP/(RP+RS) (assuming all biomass has 45\% C)}
  \item{varible_harvest_index}{Logical value, if the variable harvest index assumption of Fan et al. (2017) are to be aplied or not.}
  \item{HI_intercept}{Intercept of the variable harvest index assumption of Fan et al. (2017) are to be aplied.}
  \item{HI_slope}{Slope of the variable harvest index assumption of Fan et al. (2017) are to be aplied. [ha/tDM]}
  \item{shoot_root_ratio}{Ratio of the product and the above ground residues to the root biomass. Calculated by (RP+RS)/RR (assuming all biomass has 45\% C)}
  \item{root_exudation_factor}{Ratio of the root exudates to the root biomass. Calculated by RE/RR (assuming all biomass has 45\% C)}
  \item{fixed_belowground_input}{Logical value if the fixed below ground C allocation assumption of Taghizadeh-Toosi et al. (2020) is to be applied or not.}
  \item{C_input_root}{Fixed value of root carbon input that is to be assumed. [kgC/ha]}
  \item{Source}{Source where the information was derived.}
}
}
\usage{
C_input_crops_LUT
}
\description{
The data set is a look-up-table that is used to calculate the C inputs by
 crops with the Bolinder formula, that is implemented in the function 
 `SoilManageR::C_input_crops()`. The data set is produced from the excel table 
 `C_input_crops_LUT.xlsx` file under `/inst/extdata/`.
}
\references{
Compilation of values from the SoilX project. Please check the 
 `C_input_crops_LUT.xlsx` file under `/inst/extdata/` for more information.
 
\insertRef{bolinder2007}{SoilManageR}

\insertRef{bolinder2015}{SoilManageR}

\insertRef{fan2017}{SoilManageR}

\insertRef{hirte2018}{SoilManageR}

\insertRef{keel2017}{SoilManageR}

\insertRef{seitz2022}{SoilManageR}

\insertRef{GRUD2017_ch8}{SoilManageR}

\insertRef{taghizadeh-toosi2020}{SoilManageR}

\insertRef{wuest2020}{SoilManageR}
}
\keyword{datasets}
