% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CollectDataTwitter.R
\name{CollectDataTwitter}
\alias{CollectDataTwitter}
\title{Note: this function is DEPRECATED and will be removed in a future release.
Please use the \code{Collect} function}
\usage{
CollectDataTwitter(searchTerm, numTweets, verbose, writeToFile, language, since,
  until, locale, geocode, sinceID, maxID, resultType, retryOnRateLimit)
}
\arguments{
\item{searchTerm}{character string, specifying a search term or phrase (e.g.
"Australian politics") or hashtag (e.g. "#auspol"). Many query operators are
available - see the Twitter documentation for more information:
https://dev.twitter.com/rest/public/search}

\item{numTweets}{numeric integer, specifying how many tweets to be
collected. Defaults to 1500. Maximum tweets for a single call of this
function is 1500.}

\item{verbose}{logical. If \code{TRUE} then this function will output
runtime information to the console as it computes. Useful diagnostic tool
for long computations. Default is \code{FALSE}.}

\item{writeToFile}{logical. If \code{TRUE} then the data is saved to file in
current working directory (CSV format), with filename denoting current
system time and \code{searchTerm}. Default is \code{FALSE}.}

\item{language}{character string, restricting tweets to the given language,
given by an ISO 639-1 code. For example, "en" restricts to English tweets.
Defaults to NULL.}

\item{since}{If not NULL, restricts tweets to those since the given date. Date is to be formatted
as YYYY-MM-DD (this is a wrapper to the searchTwitter function in the twitteR package).}

\item{until}{If not NULL, restricts tweets to those up until the given date. Date is to be formatted
as YYYY-MM-DD (this is a wrapper to the searchTwitter function in the twitteR package).}

\item{locale}{If not NULL, will set the locale for the search. As of 03/06/11 only ja is effective,
as per the Twitter API (this is a wrapper to the searchTwitter function in the twitteR package).}

\item{geocode}{If not NULL, returns tweets by users located within a given radius of the given
latitude/longitude. (this is a wrapper to the searchTwitter function in the twitteR package).}

\item{sinceID}{If not NULL, returns tweets with IDs greater (ie newer) than the specified ID
(this is a wrapper to the searchTwitter function in the twitteR package).}

\item{maxID}{If not NULL, returns tweets with IDs smaller (ie older) than the specified ID
(this is a wrapper to the searchTwitter function in the twitteR package).}

\item{resultType}{If not NULL, returns filtered tweets as per value. See details for allowed values.
(this is a wrapper to the searchTwitter function in the twitteR package).}

\item{retryOnRateLimit}{If non-zero the search command will block retry up to X times if the rate limit
is experienced. This might lead to a much longer run time but the task will
eventually complete if the retry count is high enough (this is a wrapper to the searchTwitter
function in the twitteR package).}
}
\value{
A data frame object of class \code{dataSource.twitter} that can be
used for creating unimodal networks (\code{CreateActorNetwork}), bimodal
networks (\code{CreateBimodalNetwork}), and semantic networks
(\code{CreateSemanticNetwork}).
}
\description{
Collect data from Twitter for generating different types of networks
}
\details{
This function collects data from Twitter based on hashtags or search terms,
and structures the data into a data frame of class
\code{dataSource.twitter}, ready for creating networks for further analysis.

\code{CollectDataTwitter} collects public 'tweets' from Twitter using the
Twitter API.

The function then finds and maps the relationships of entities of interest
in the data (e.g. users, terms, hashtags), and structures these
relationships into a data frame format suitable for creating unimodal
networks (\code{CreateActorNetwork}), bimodal networks
(\code{CreateBimodalNetwork}), and semantic networks
(\code{CreateSemanticNetwork}).

The maximum number of tweets for a single call of \code{CollectDataTwitter}
is 1500.

Language support is available, using the \code{language} argument. The user
can restrict tweets returned to a particular language, using the ISO 639-1
code. For example, restricting to English would use \code{language="en"}.
The full list of codes is available here:
https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes.

A variety of query operators are available through the Twitter API. For
example, "love OR hate" returns any tweets containing either term (or both).
For more information see the Twitter API documentation (under the heading
'Query Operators'): https://dev.twitter.com/rest/public/search
}
\note{
Data generated using this function is *not* suitable for dynamic
networks. Dynamic Twitter networks are not currently implemented in the
SocialMediaLab package. This will be implemented in a future release.
}
\examples{

\dontrun{
  # Firstly specify your API credentials
  my_api_key <- "1234567890qwerty"
  my_api_secret <- "1234567890qwerty"
  my_access_token <- "1234567890qwerty"
  my_access_token_secret <- "1234567890qwerty"

  # Authenticate with the Twitter API using \\code{AuthenticateWithTwitterAPI}
  AuthenticateWithTwitterAPI(api_key=my_api_key, api_secret=my_api_secret,
    access_token=my_access_token, access_token_secret=my_access_token_secret)

  # Collect tweets data using \\code{myTwitterData}
  myTwitterData <- CollectDataTwitter(searchTerm="#auspol",
    numTweets=150,writeToFile=FALSE,verbose=FALSE)

  # Create an 'actor' network using \\code{CreateActorNetwork}
  g_actor_twitter <- CreateActorNetwork(myTwitterData)

  # Create a 'bimodal' network using \\code{CreateBimodalNetwork}
  g_bimodal_twitter <- CreateBimodalNetwork(myTwitterData)

  # Create a 'semantic' network using \\code{CreateSemanticNetwork}
  g_semantic_twitter <- CreateSemanticNetwork(myTwitterData)
  }
}
\author{
Timothy Graham <timothy.graham3@uq.net.au> & Robert Ackland
<robert.ackland@anu.edu.au>
}
\seealso{
\code{AuthenticateWithTwitterAPI} must be run first or no data will
be collected.
}
\keyword{SNA}
\keyword{data}
\keyword{mining}
\keyword{twitter}

