% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvar.R
\name{pvar}
\alias{pvar}
\title{Prints the name and value of one or more objects}
\usage{
pvar(..., digits = NULL, abbrev = NULL, sep = ";", verbose = TRUE)
}
\arguments{
\item{digits}{Number of digits to display for numeric objects.  Defaults to
\code{NULL}, which corresponds to no restriction on the number of digits.  This
is passed to the \code{digits} argument of \code{\link{round}}.}

\item{abbrev}{Number of characters to display for character objects.
Defaults to \code{NULL}, which corresonds to no restriction on the number
of characters.}

\item{sep}{Character string that separates the objects that are printed}

\item{verbose}{\code{=TRUE} writes the value of the object(s) to the
session window}

\item{\dots}{Objects whose names and values are to be printed, separated by
commas. Can also be a simple list.}
}
\value{
Invisibly returns a character string containing the names of the
objects and their values
}
\description{
A convenience function for writing the names and values of objects to the
session window (and/or to another object).  Especially useful to keep track
of variables within loops.
}
\details{
Input objects can be numeric, character, and/or logical.  They can also be
atomic or vectors.  It will accept data frames and matrices without error,
but the results won't be easily readable.
}
\examples{
x <- 10
y <- 20.728923
z <- "This.long.string"

pvar(x, y, z)
pvar(x, y, z, digits = 2)
pvar(x, y, z, abbrev = 4)
pvar(x, y, z, digits = 2, abbrev = 4)
pvar(x, y, z, sep = ",")

# values can be vectors too
x <- 10:12
y <- c("This","That")
v2 <- pvar(x, y, verbose = FALSE)
v2

# Or a simple list
pvar(list(x = 1:2, y = "this", z = TRUE))

# Can be useful for keeping track of iterations in loops
for (i in 1:2) {
  for (j in letters[1:2]) {
    for (k in c("this","that")) {
      pvar(i, j, k)
    }
  }
}
}
\author{
Landon Sego
}
\keyword{misc}

