% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simslapmeg.R
\name{simslapmeg}
\alias{simslapmeg}
\title{Simulate longitudinal data based on a shared latent process mixed effects model (SlaPMEG)}
\usage{
simslapmeg(
  nY,
  ntime,
  nsubj,
  pDif = 1/3,
  fixed = ~1 + time,
  random = ~1 + time,
  fixedbeta = c(0, 2),
  randbeta = c(0, 2),
  group,
  groupbeta = 2,
  sigma.b,
  sigma.u,
  seed = as.integer(runif(1, 0, .Machine$integer.max)),
  returnpar = FALSE
)
}
\arguments{
\item{nY}{number of omics in the data}

\item{ntime}{number of repeated measures}

\item{nsubj}{number of subjects}

\item{pDif}{proportion of differentially expressed omics in the data (the default is 1/3)}

\item{fixed}{A one-sided formula for the fixed-effects excluding the group variable, the default includes an
intercept and time}

\item{random}{A one-sided formula for the random-effects, the default includes an intercept and time}

\item{fixedbeta}{effect size of fixed terms in formula, the length should match the fixed formula,
the default is 0 (intercept) and 2 (time)}

\item{randbeta}{effect size of random terms in formula, the length should match the random formula,
the default is 0 (intercept) and 2 (time)}

\item{group}{Vector indicating group membership, the length should match the number of subjects,
The default is random allocation of half of subjects to each group.
If use with slapmeg is intended, the group variable should have only two groups}

\item{groupbeta}{effect size of group variable, the default is 2}

\item{sigma.b}{variance of the omic- / subject- specific random effects, the length should math \code{nY}.
If not specified, \code{nY} values from normal distribution will be randomly assigned.}

\item{sigma.u}{Variance of the subject-specific random effects, the length should math the random effects defined
in random formula. If not specified, 2 values from normal distribution will be randomly assigned.}

\item{seed}{Value of seed, if not specified a random integer will be assigned}

\item{returnpar}{logical if TRUE, all simulation parameters will be returned along with the simulated data.}
}
\value{
Returns a dataframe where the rows represent the observations and the columns
represent the subject Id, time and group variable followed by the omics in pathway; if returnpar is TRUE,
a list with both data and parametrs is returned
}
\description{
This is a simple function to simulate longitudinal data from a shared latent process mixed effects model
the data provides a good example for application of \code{slapmeg} and \code{pairslapmeg}
and \code{pairslapmeg} objects.
}
\seealso{
\code{\link{slapmeg}}, \code{\link{pairslapmeg}}
}
\author{
Mitra Ebrahimpoor
}
\keyword{simulate}
