% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setinval.R
\name{setinval}
\alias{setinval}
\title{Estimating initial values for slapmeg based on seperate lme models}
\usage{
setinval(fixed, random, subject, data)
}
\arguments{
\item{fixed}{A two-sided linear formula object for specifying the
fixed-effects in the linear mixed model at the latent process level. Names
of omics in the pathway are separated by \code{+} on the left of \code{~} and the
covariates are separated by \code{+} on the right of the \code{~}. For
identifiability purposes, the intercept should always be present in the model.}

\item{random}{A one-sided formula for the random-effects in the
latent process mixed model and starts with the \code{~} sign. At least one random
effect should be included. Covariates with a random-effect are separated
by \code{+}.}

\item{subject}{name of the covariate representing the repeated measures structure such as subject IDs.}

\item{data}{data frame containing the variables named in \code{fixed}, \code{random},
\code{grouping} and \code{subject}.}
}
\value{
A vector of initial values to be used as input for multlcmm function
}
\description{
A seperate lme model is fited per omic in the pathway and the estimates are combined to create
initial values for the \code{\link{slapmeg}} function.
}
\author{
Mitra Ebrahimpoor

\email{m.ebrahimpoor@lumc.nl}
}
