% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairslapmeg.R
\name{pairslapmeg}
\alias{pairslapmeg}
\title{Testing pathways using SLaPMEG (shared latent process mixed effects model and Globaltest) for
longitudinal Omics data based on pairwise estimation approach (a computational solution for
latrge pathways)}
\usage{
pairslapmeg(fixed, random, grouping, subject, data)
}
\arguments{
\item{fixed}{A two-sided linear formula object for specifying the
fixed-effects in the linear mixed model at the latent process level. Names
of omics in the pathway are separated by \code{+} on the left of \code{~} and the
covariates are separated by \code{+} on the right of the \code{~}. For
identifiability purposes, the intercept should always be present in the model.}

\item{random}{A one-sided formula for the random-effects in the
latent process mixed model and starts with the \code{~} sign. At least one random
effect should be included. Covariates with a random-effect are separated
by \code{+}.}

\item{grouping}{name of the covariate representing grouping by the phenotype}

\item{subject}{name of the covariate representing the repeated measures structure such as subject IDs.}

\item{data}{data frame containing the variables named in \code{fixed}, \code{random},
\code{grouping} and \code{subject}.}
}
\value{
A list is returned including: \item{call}{the matched call} \item{nfix}{Number
of fixed effect terms in the model, excluding the mandatory intercept} \item{nrand}{Number of
random effect terms in the model} \item{nsubj}{Number of subjects in the sataset} \item{nrep}{
Table of repeated measures, and number of subjects with the specified number of repeated measures}
\item{tgroup}{Table of grouping, and number of subjects in each group} \item{Ynames}{Name of the
Omics in the pathway} \item{slapconv}{Status of convergence: For joint method(=1 if the convergence
criteria were satisfied, =2 if the maximum number of iterations was reached, =4 or 5 if a problem
occured during optimisation); for the pairwise method, proportion of successfully converged pairs
is reported} \item{fixedform}{Names of Fixed effect terms} \item{randform}{Names of random effect
terms} \item{slapmethod}{The method which is "joint" if the original slapmeg approach is adopted
and pairwise for the pairwise method} \item{SLaP.par}{Fitted values for
the parameters in the joint class mixed model in the first step} \item{Globaltest}{The output
from Globaltest at the second step} \item{EB_pred}{Empirical
bayes estimates for the random effects from the joint model}
}
\description{
This function performs pathway testing for longitudinal omics within a two-step framework
just as in \code{\link{slapmeg}} but instead of using a joint shared latent model in the
first step, it uses a pairwise approach and runs much faste for larger pathways.
After estimating the random effects of the joint model using pairwise fitting, the random
effects are used within globaltest to compare the two groups at a pathway level.
}
\examples{


# simulate data with 15 omics
testdata<-simslapmeg(nY=25, ntime=3, nsubj = 30)
head(testdata)

#fit slapmeg to test for the differential expression of a pathway of size 15
slapmegfit<- pairslapmeg(Y1+Y2+Y6+Y7+Y8~time, ~1, grouping="group", subject="ID", data=testdata)
slapmegfit
summary(slapmegfit)

}
\references{
paper DOI will be added
}
\seealso{
\code{\link{slapmeg}}, \code{\link{multslapmeg}}, \code{\link{plotslapmeg}}
}
\author{
Mitra Ebrahimpoor

\email{m.ebrahimpoor@lumc.nl}
}
