% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcr.profiles.R
\name{plotControlProfiles}
\alias{plotControlProfiles}
\title{Profiles control plot}
\usage{
plotControlProfiles(pOut, tol = 0.5)
}
\arguments{
\item{pOut}{identifiers of profiles out of control}

\item{tol}{tolerance for the proportion of times the value of the profile is out of control}
}
\value{
There is only graphical output
}
\description{
Plots the proportion of times that each profile remains 
out of the confidence bands
}
\examples{
wby.phase1 <- ss.data.wby[, 1:35]
wb.limits <- climProfiles(profiles = wby.phase1,
    x = ss.data.wbx,
    smoothprof = TRUE,
    smoothlim = TRUE)
wby.phase2 <- ss.data.wby[, 36:50]
wb.out.phase2 <- outProfiles(profiles = wby.phase2,
    x = ss.data.wbx,
    cLimits = wb.limits,
    tol = 0.8)
plotControlProfiles(wb.out.phase2$pOut, tol = 0.8)
}
\references{
Cano, E.L. and Moguerza, J.M. and Prieto Corcoba, M. (2015)
\emph{Quality Control with R. An ISO Standards Approach}. Springer.
}
\author{
Javier M. Moguerza and Emilio L. Cano
}
