% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate-effect-sizes.R
\name{calc_ES}
\alias{calc_ES}
\title{Calculate effect sizes}
\usage{
calc_ES(A_data, B_data, condition, outcome, baseline_phase = NULL,
  intervention_phase = NULL, ES = c("LRRd", "LRRi", "SMD", "Tau"),
  improvement = "increase", ..., confidence = 0.95, format = "long")
}
\arguments{
\item{A_data}{vector of numeric data for A phase. Missing values are dropped.}

\item{B_data}{vector of numeric data for B phase. Missing values are dropped.}

\item{condition}{vector identifying the treatment condition for each
observation in the series.}

\item{outcome}{vector of outcome data for the entire series.}

\item{baseline_phase}{character string specifying which value of
\code{condition} corresponds to the baseline phase. Defaults to first
observed value of \code{condition}.}

\item{intervention_phase}{character string specifying which value of
\code{condition} corresponds to the intervention phase. Defaults to second
unique value of \code{condition}.}

\item{ES}{character string or character vector specifying which effect size
index or indices to calculate. Available effect sizes are \code{"LRRd"},
\code{"LRRi"}, \code{"LOR"}, \code{"SMD"}, \code{"NAP"}, \code{"IRD"},
\code{"PND"}, \code{"PEM"}, \code{"PAND"}, \code{"Tau"}, and
\code{"Tau-U"}. Set to \code{"all"} for all available effect sizes. Set to
\code{"parametric"} for all parametric effect sizes. Set to \code{"NOM"}
for all non-overlap measures. Defaults to calculating the LRRd, LRRi, SMD,
and Tau indices.}

\item{improvement}{character string indicating direction of improvement.
Default is "increase".}

\item{...}{further arguments used for calculating some of the effect size
indices.}

\item{confidence}{confidence level for the reported interval estimate. Set to
\code{NULL} to omit confidence interval calculations.}

\item{format}{character string specifying whether to organize the results in
\code{"long"} format or \code{"wide"} format. Defaults to \code{"long"}.}
}
\value{
A data.frame containing the estimate, standard error, and/or
  confidence interval for each specified effect size.
}
\description{
Calculates one or more effect size estimates, along with
  associated standard errors and confidence intervals, if available, for a
  single-case data series.
}
\details{
Calculates one or more effect size indices
}
\examples{
# Using the A_data and B_data arguments
A <- c(20, 20, 26, 25, 22, 23)
B <- c(28, 25, 24, 27, 30, 30, 29)
calc_ES(A_data = A, B_data = B)

# Using the condition and outcome arguments
phase <- c(rep("A", length(A)), rep("B", length(B)))
outcome <- c(A, B)
calc_ES(condition = phase, outcome = outcome, baseline_phase = "A")

# Example from Parker & Vannest (2009)
yA <- c(4, 3, 4, 3, 4, 7, 5, 2, 3, 2)
yB <- c(5, 9, 7, 9, 7, 5, 9, 11, 11, 10, 9)
calc_ES(yA, yB)

}
