% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-overlap-measures.R
\name{IRD}
\alias{IRD}
\title{Robust improvement rate difference}
\usage{
IRD(A_data, B_data, condition, outcome, baseline_phase = unique(condition)[1],
  improvement = "increase")
}
\arguments{
\item{A_data}{vector of numeric data for A phase. Missing values are dropped.}

\item{B_data}{vector of numeric data for B phase. Missing values are dropped.}

\item{condition}{vector identifying the treatment condition for each
observation in the series.}

\item{outcome}{vector of outcome data for the entire series.}

\item{baseline_phase}{character string specifying which value of
\code{condition} corresponds to the baseline phase. Defaults to first
observed value of \code{condition}.}

\item{improvement}{character string indicating direction of improvement.
Default is "increase".}
}
\value{
Numeric value
}
\description{
Calculates the robust improvement rate difference index (Parker,
  Vannest, & Brown, 2009). The range of IRD depends on the number of 
  observations in each phase.
}
\examples{
A <- c(20, 20, 26, 25, 22, 23)
B <- c(28, 25, 24, 27, 30, 30, 29)
IRD(A_data = A, B_data = B)

}
\references{
Parker, R. I., Vannest, K. J., & Brown, L. (2009). The
  improvement rate difference for single-case research. \emph{Exceptional Children,
  75}(2), 135--150. doi:\href{http://dx.doi.org/10.1177/001440290907500201}{10.1177/001440290907500201}
}
\seealso{
\code{\link{PAND}}
}
