% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dem_reg.R
\name{dem_reg}
\alias{dem_reg}
\title{Deming Regression}
\usage{
dem_reg(
  x,
  y,
  id = NULL,
  data,
  conf.level = 0.95,
  weighted = FALSE,
  weights = NULL,
  error.ratio = 1,
  keep_data = FALSE
)
}
\arguments{
\item{x}{Name of column with first measurement}

\item{y}{Name of other column with the other measurement to compare to the first.}

\item{id}{Column with subject identifier}

\item{data}{Data frame with all data}

\item{conf.level}{The confidence level required. Default is 95\%.}

\item{weighted}{Logical indicator (TRUE/FALSE) for whether to use weighted Deming regression. Default is FALSE.}

\item{weights}{an optional vector of weights to be used in the fitting process. Should be NULL or a numeric vector.}

\item{error.ratio}{Ratio of the two error variances. Default is 1. This argument is ignored if subject identifiers are provided.}

\item{keep_data}{Logical indicator (TRUE/FALSE). If TRUE the jacknife samples are returned; default is FALSE.}
}
\value{
The function returns a simple_eiv (eiv meaning "error in variables") object.

\describe{
  \item{\code{"call"}}{The matched call.}
  \item{\code{"model"}}{Data frame presenting the results from the Deming regression analysis.}
  \item{\code{"resamples"}}{List containing resamples from jacknife procedure.}
}
}
\description{
A function for fitting a straight line to two-dimensional data (i.e., X and Y) are measured with error.
}
\details{
This function provides a Deming regression analysis wherein the sum of distances in both x and y direction is minimized.
Deming is useful in situations where both X & Y are measured with error.
The use of Deming regression is beneficial when comparing to methods for measuring the same continuous variable.

Currently, the dem_reg function covers simple Deming regression and weighted Deming regression. Weighted Deming regression can be used by setting weighted to TRUE. The weights can be provided by the user or can be calculated within function.

If the data are measured in replicates, then the measurement error can be directly derived from the data. This can be accomplished by indicating the subject identifier with the id argument.
When the replicates are not available in the data, then the ratio of error variances (y/x) can be provided with the error.ratio argument.
}
\section{References}{

Linnet, K. (1990) Estimation of the linear relationship between the measurements of two methods with proportional errors. Statistics in Medicine, 9, 1463-1473.

Linnet, K. (1993). Evaluation of regression procedures for methods comparison studies. Clinical chemistry, 39, 424-432.
}

