% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Validation_Functions.R
\name{sim_pop}
\alias{sim_pop}
\title{Simulate survival data for a population sample}
\usage{
sim_pop(nlives, hazard_rates, GRR, YOB, stop_year, RV_status = NULL,
  carrier_prob = 0.002)
}
\arguments{
\item{nlives}{Numeric.  The number of individuals to simulate}

\item{hazard_rates}{An object of class \code{hazard}, created by \code{\link{hazard}}.}

\item{GRR}{Numeric. The genetic relative-risk of disease, i.e. the relative-risk of disease for individuals who carry at least one copy of the causal variant.  Note: When simulating diseases with multiple subtypes \code{GRR} must contain one entry for each simulated subtype.  See details.}

\item{YOB}{Numeric. The year of birth for all individuals in the sample.}

\item{stop_year}{Numeric. The last year of the study, i.e. the last year we can observe data.}

\item{RV_status}{Numeric.  The rare variant status for all individuals in the study. \code{RV_status = 1} if carrier of the cRV, otherwise \code{RV_status = 0}.  By default, \code{RV_status = NULL} so that the cRV status is simulated based on \code{carrier_prob}.}

\item{carrier_prob}{Numeric.  The carrier probability for all causal variants with relative-risk of disease \code{GRR}.  By default, \code{carrier_prob}\code{ = 0.002}}
}
\value{
A data frame of event times and classifiers for the simulated individuals.
}
\description{
This function is under construction. Plan to release in an update after function level testing has been implemented.
}
\keyword{internal}
