% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PedSim_Functions.R
\name{sim_nFam}
\alias{sim_nFam}
\title{Simulate a nuclear family from a single founder}
\usage{
sim_nFam(found_info, stop_year, last_id, hazard_rates, NB_params, GRR,
  carrier_prob, RVfounder, fert)
}
\arguments{
\item{found_info}{Data.frame with 1 row. All pedigree information for the founder, must contain all fields generated by \code{\link{create_pedFile}}.}

\item{stop_year}{Numeric. The last year of study.  If not supplied, defaults to the current year.}

\item{last_id}{Numeric.  The last id used in the pedigree.}

\item{hazard_rates}{An object of class \code{hazard}, created by \code{\link{hazard}}.}

\item{NB_params}{Numeric vector of length 2. The size and probability parameters of the negative binomial distribution used to model the number of children per household.  By default, \code{NB_params}\code{ = c(2, 4/7)}, due to the investigation of Kojima and Kelleher (1962).}

\item{GRR}{Numeric. The genetic relative-risk of disease, i.e. the relative-risk of disease for individuals who carry at least one copy of the causal variant.  Note: When simulating diseases with multiple subtypes \code{GRR} must contain one entry for each simulated subtype.  See details.}

\item{carrier_prob}{Numeric.  The carrier probability for all causal variants with relative-risk of disease \code{GRR}.  By default, \code{carrier_prob}\code{ = 0.002}}

\item{RVfounder}{Logical.  Indicates if all pedigrees segregate the rare, causal variant.  By default, \code{RVfounder = FALSE} See details.}

\item{fert}{Numeric.  A constant used to rescale the fertility rate after disease-onset. By default, \code{fert = 1}.}
}
\value{
A pedigree with updated life events for the founder, and
additional information for mate and offspring, when offspring are generated.
}
\description{
Simulate all life events for an individual and create a nuclear family, when appropriate.
}
\keyword{internal}
