% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PedSim_Functions.R
\name{create_offspring}
\alias{create_offspring}
\title{Create a new offspring}
\usage{
create_offspring(dad_info, mom_info, byear, last_id, GRR)
}
\arguments{
\item{dad_info}{Data.frame with 1 row. All pedigree information of offspring's father, must contain all fields generated by \code{\link{create_pedFile}}.}

\item{mom_info}{Data.frame with 1 row. All pedigree information of offspring's mother, must contain all fields generated by \code{\link{create_pedFile}}.}

\item{byear}{The birth year of offspring.}

\item{last_id}{Numeric.  The last id used in the pedigree.}

\item{GRR}{Numeric. The genetic relative-risk of disease, i.e. the relative-risk of disease for individuals who carry at least one copy of the causal variant.  Note: When simulating diseases with multiple subtypes \code{GRR} must contain one entry for each simulated subtype.  See details.}
}
\value{
new_child_info the pedigree information for the new child

last_id the updated value of last_id after adding new offspring
}
\description{
Create new offspring in pedigree.
}
\keyword{internal}
