% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_indiv_events.R
\name{node_events}
\alias{node_events}
\alias{node_events,SimInf_indiv_events-method}
\title{Transform individual events to node events for a model}
\usage{
node_events(x, time = NULL, target = NULL, age = NULL)

\S4method{node_events}{SimInf_indiv_events}(x, time = NULL, target = NULL, age = NULL)
}
\arguments{
\item{x}{an individual events object of class
\code{SimInf_indiv_events}.}

\item{time}{All events that occur after \sQuote{time} are
included. Default is \code{NULL} which means to extract the
events after the minimum time-point in the
\code{SimInf_indiv_events} object.}

\item{target}{The SimInf model ('SEIR', 'SIR', 'SIS', 'SISe3',
'SISe3_sp', 'SISe', or 'SISe_sp') to target the events and u0
for. The default, \code{NULL}, creates events but they might
have to be post-processed to fit the specific use case.}

\item{age}{Integer vector with break points in days for the ageing
events.}
}
\value{
a \code{data.frame} with the columns \code{event},
    \code{time}, \code{node}, \code{dest}, \code{n},
    \code{proportion}, \code{select}, and \code{shift}.
}
\description{
In many countries, individual-based livestock data are collected
to enable contact tracing during disease outbreaks. However, the
livestock databases are not always structured in such a way that
relevant information for disease spread simulations is easily
retrieved. The aim of this function is to facilitate cleaning
livestock event data and prepare it for usage in SimInf.
}
\details{
The individual-based events will be aggregated on node-level.  The
\code{select} value is determined by the event type and age
category.  If there is only one age category, i.e.,
\code{age=NULL}, then \code{select=1} for the enter events, and
\code{select=2} for all other events. If there are two age
categories, then \code{select=1} for the enter events in the first
age category, and \code{select=2} for the enter events in the
second age category. Similarly, \code{select=3} for all other
events in the first age category, and \code{select=4} for all
other events in the first second category. With three age
categories, it works similarly with \code{select=1,2,3} for the
enter events in each age category, respectively. And
\code{select=4,5,6} for all other events.
}
\seealso{
\code{\link{individual_events}}.
}
