% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_creator.R
\name{add_creator}
\alias{add_creator}
\title{Add a "creator" function}
\usage{
add_creator(sim, name, fn)
}
\arguments{
\item{sim}{A simulation object of class \code{sim_obj}, usually created by
\code{\link{new_sim}}}

\item{name}{A name for the creator function}

\item{fn}{A creator function}
}
\value{
The original simulation object with the new creator function added
}
\description{
Add a "creator" function to your simulation object. A creator is
    a function that generates a dataset for use in your simulation.
}
\details{
\itemize{
  \item{There are two ways to use \code{add_creator}. If two arguments are
    supplied (\code{sim} and \code{fn}), you can create a function
    separately and add it to your simulation object later. If three arguments
    are supplied, you can do both at the same time, using an anonymous
    function for the \code{fn} argument. See examples.}
  \item{Your creator will be stored in \code{sim$creators}. If you added a
    creator called \code{create_data}, you can test it out by running
    \code{sim$creators$create_data()}. See examples.}
}
}
\examples{
# The first way to use add_creator is to declare a function and add it to
# your simulation object later:

sim <- new_sim()
create_data <- function (n) { rpois(n, lambda=5) }
sim \%<>\% add_creator(create_data)

# The second way is to do both at the same time:

sim <- new_sim()
sim \%<>\% add_creator("create_data", function(n) {
  rpois(n, lambda=5)
})

# With either option, you can test your function as follows:

sim$creators$create_data(10)
}
