rmar.cumlink <-
function(clsize,lin.pred,cor.matrix,cuts,link="probit")
{
 if(!is.numeric(clsize) | clsize < 2)
     stop("'clsize' must be greater than or equal to two")
 clsize <- as.integer(clsize) 
 lin.pred <- as.matrix(lin.pred)
 if(!is.numeric(lin.pred))
     stop("'lin.pred' must be a numeric")
 if(ncol(lin.pred)!=clsize) 
     stop("the matrix 'lin.pred' must have ",clsize,"columns")
 R <- nrow(lin.pred)
 if(!is.list(cuts) & !is.vector(cuts))
    stop("'cuts' must be a list or a vector")
 if(is.vector(cuts)) {
    if(!is.numeric(cuts))
       stop("'cuts' must be numeric")
    cuts.list <- list(cuts)
    for(i in 2:clsize) cuts.list[[i]] <- cuts
                    } else {
    if(!is.numeric(unlist(cuts)))
       stop("'cuts' must be numeric")
       cuts.list <- list(cuts)
    if(!(length(cuts.list)==clsize)) 
      stop("'cuts' must have length equal to ",clsize)
                            } 
 if(any(unlist(lapply(cuts.list,diff))<=0)) 
    stop("'cuts' must be increasing") 
 if(sum(unlist(cuts.list)==-Inf)!=clsize)
   stop("'-Inf' must be the minimum cutpoint at each occasion")
 if(sum(unlist(cuts.list)==Inf)!=clsize)
   stop("'Inf' must be the maximum cutpoint at each occasion")                 
 links <- c("probit","logit","cloglog","cauchit")
  if(!is.element(link,links)) 
   stop("'link' must be either 'probit','logit','cloglog','cauchit'") 
  distr <- switch(link,"probit"="normal","logit"="logistic",
                       "cloglog"="extreme","cauchit"="cauchit")
 if(!is.numeric(cor.matrix)) 
    stop("'cor.matrix' must be numeric")
 if(!is.matrix(cor.matrix) & !is.vector(cor.matrix))
    stop("'cor.matrix' must be matrix or a vector")
 if(is.matrix(cor.matrix))
   {
  if(ncol(cor.matrix)!=clsize) 
    stop("'cor.matrix' must be ",clsize,"x",clsize," matrix")
  if(!isSymmetric(cor.matrix)) 
    stop("'cor.matrix' must be symmetric") 
  if(any(diag(cor.matrix)!=1)) 
    stop("the diagonal elements of 'cor.matrix' must be one")
  if(any(cor.matrix>1) | any(cor.matrix< -1))
    stop("all the elements of 'cor.matrix' must be on [-1,1]")
  if(any(eigen(cor.matrix,symmetric=TRUE,only.values=TRUE)$values<0))
    stop("'cor.matrix' must be semi-positive definite")
  err <- rtransfam(R=R,cor.matrix=cor.matrix,distr=distr)
   } else {
 if(distr=="normal" | distr=="cauchit") 
    stop("'cor.matrix' must be a matrix when 'link'=probit or cauchit")
 if(any(cor.matrix>1) | any(cor.matrix<=0))
     stop("all the elements of 'cor.matrix' must be on [0,1)") 
 if(sum(cor.matrix)>1)
     stop("the sum of 'cor.matrix' must be less than 1") 
 if(distr=="extreme") 
    err <- rmvevd(n=R,dep=sqrt(1-cor.matrix[[1]]),d=clsize) else {
 if(length(cor.matrix)==1){
 err <- rmvevd(n=R,dep=sqrt(1-cor.matrix),d=clsize)-
        rmvevd(n=R,dep=sqrt(1-cor.matrix),d=clsize)
                          } else {
 err <- rmvevd(n=R,dep=sqrt(1-cor.matrix[[1]]),d=clsize)-
        rmvevd(n=R,dep=sqrt(1-cor.matrix[[2]]),d=clsize)
                                 }
            }
         }
 if(!is.matrix(cor.matrix)) {
    cor.matrix <- if(length(cor.matrix)>1 & distr=="logistic") 
                     mean(cor.matrix[1:2]) else cor.matrix[[1]]
    cor.matrix <- toeplitz(c(1,rep(cor.matrix,clsize-1)))
                             }
 U <- -lin.pred+err
 Ysim <- matrix(0,nrow=R,ncol=clsize)
 for(j in 1:clsize) Ysim[,j] <- cut(U[,j],cuts.list[[j]],ordered_result=TRUE)
 list(Ysim=Ysim,correlation=cor.matrix,cuts=cuts.list,error=err)
 }

