% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{GetMotifData}
\alias{GetMotifData}
\alias{GetMotifData.Motif}
\alias{GetMotifData.ChromatinAssay}
\alias{GetMotifData.Seurat}
\title{Retrieve a motif matrix}
\usage{
GetMotifData(object, ...)

\method{GetMotifData}{Motif}(object, slot = "data", ...)

\method{GetMotifData}{ChromatinAssay}(object, slot = "data", ...)

\method{GetMotifData}{Seurat}(object, assay = NULL, slot = "data", ...)
}
\arguments{
\item{object}{A Seurat object}

\item{...}{Arguments passed to other methods}

\item{slot}{Information to pull from object (data, pwm, meta.data)}

\item{assay}{Which assay to use. Default is the current active assay}
}
\value{
Returns a \code{\link[SeuratObject]{Seurat}} object
}
\description{
Get motif matrix for given assay
}
\examples{
motif.obj <- SeuratObject::GetAssayData(
  object = atac_small[['peaks']], slot = "motifs"
)
GetMotifData(object = motif.obj)
GetMotifData(object = atac_small)
}
\concept{motifs}
