% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{SortIdents}
\alias{SortIdents}
\title{Sorts cell metadata variable by similarity using hierarchical clustering}
\usage{
SortIdents(
  object,
  layer = "data",
  assay = NULL,
  label = NULL,
  dendrogram = FALSE,
  method = "euclidean",
  verbose = TRUE
)
}
\arguments{
\item{object}{A Seurat object containing single-cell data.}

\item{layer}{The layer of the data to use (default is "data").}

\item{assay}{Name of assay to use. If NULL, use the default assay}

\item{label}{Metadata attribute to sort. If NULL, 
uses the active identities.}

\item{dendrogram}{Logical, whether to plot the dendrogram (default is FALSE).}

\item{method}{The distance method to use for hierarchical clustering
(default is 'euclidean', other options from \code{\link[stats]{dist}} are
'maximum', 'manhattan', 'canberra', 'binary' and 'minkowski').}

\item{verbose}{Display messages}
}
\value{
The Seurat object with metadata variable reordered by similarity.
If the metadata variable was a character vector, it will be converted to a
factor and the factor levels set according to the similarity ordering. If
active identities were used (label=NULL), the levels will be updated according
to similarity ordering.
}
\description{
Compute distance matrix from a feature/variable matrix and 
perform hierarchical clustering to order variables (for example, cell types)
according to their similarity.
}
\examples{
atac_small$test <- sample(1:10, ncol(atac_small), replace = TRUE)
atac_small <- SortIdents(object = atac_small, label = 'test')
print(levels(atac_small$test))

}
\concept{utilities}
