% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinreg.r
\name{sinreg}
\alias{sinreg}
\title{Function that carries out a sinusoidal regression}
\usage{
sinreg(x, y, plot = FALSE)
}
\arguments{
\item{x}{Vector of \code{x} values of input data}

\item{y}{Vector of \code{y} values of input data}

\item{plot}{Should the fitting result be plotted? \code{TRUE/FALSE}}
}
\value{
A list containing a vector of parameters of the fitted sinusoid
and the fitted values belonging to each \code{x} value.
Fitting parameters:
\code{I} = the mean annual value of the sinusoid (height)
\code{A} = the amplitude of the sinusoid
\code{Dper} = the period of the sinusoid in \code{x} domain
\code{peak} = the location of the peak in the sinusoid
\code{R2adj} = the adjusted \code{R^2} value of the fit
\code{p} = the p-value of the fit
}
\description{
Fits a sinusoid through data provided as an \code{x} and \code{y}
vector and returns a list containing both the fitted curve and the
parameters of that curve.
Used to produce initial values for modelling data windows and later
to find peaks in modelled julian day values to align the result to
a cumulative age timeline.
}
\examples{
# Create dummy data
x <- seq(1000, 11000, 1000)
y <- sin((2 * pi * (seq(1, 11, 1) - 8 + 7 / 4)) / 7)
sinlist <- sinreg(x, y, plot = FALSE) # Run the function
}
