% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sr.r
\name{del_sropt}
\alias{del_sropt}
\title{Create an 'del_sropt' object.}
\usage{
del_sropt(z.s,z.sub,df1,df2,df1.sub,drag=0,ope=1,epoch="yr")
}
\arguments{
\item{z.s}{an optimum Sharpe ratio statistic, on some set of assets.}

\item{z.sub}{an optimum Sharpe ratio statistic, on a linear subspace
of the assets.  If larger than \code{z.s} an error is thrown.}

\item{df1}{the number of assets in the portfolio.}

\item{df2}{the number of observations.}

\item{df1.sub}{the rank of the linear subspace of the hedge
constraint.
by restricting attention to the subspace.}

\item{drag}{the 'drag' term, \eqn{c_0/R}{c0/R}. defaults to 0. It is assumed
that \code{drag} has been annualized, \emph{i.e.} has been multiplied
by \eqn{\sqrt{ope}}{sqrt(ope)}. This is in contrast to the \code{c0}
term given to \code{\link{sr}}.}

\item{ope}{the number of observations per 'epoch'. For convenience of
interpretation, The Sharpe ratio is typically quoted in 'annualized'
units for some epoch, that is, 'per square root epoch', though returns
are observed at a frequency of \code{ope} per epoch.
The default value is 1, meaning the code will not attempt to guess,
what the observation frequency is, and no annualization adjustments
will be made.}

\item{epoch}{the string representation of the 'epoch', defaulting
to 'yr'.}
}
\value{
a list cast to class \code{del_sropt}, with attributes
\item{sropt}{the optimal Sharpe statistic.}
\item{sropt.sub}{the optimal Sharpe statistic on the subspace.}
\item{df1}{the number of assets.}
\item{df2}{the number of observed vectors.}
\item{df1.sub}{the input \code{df1.sub} term.}
\item{drag}{the input \code{drag} term.}
\item{ope}{the input \code{ope} term.}
\item{T2}{the Hotelling \eqn{T^2} statistic.}
\item{T2.sub}{the Hotelling \eqn{T^2} statistic on the subspace.}

roll.own <- sropt(z.s=z,z.sub=zsub,df1=10,df2=1000,df1.sub=df1.sub,ope=ope)
}
\description{
Spawns an object of class \code{del_sropt}.
}
\details{
The \code{del_sropt} class contains information about the difference
between two rescaled T^2-statistics, useful for spanning
tests, and inference on hedged portfolios.
The following are list attributes of the object:
\itemize{
\item \code{sropt} The (optimal) Sharpe ratio statistic of
the 'full' set of assets.
\item \code{sropt_sub} The (optimal) Sharpe ratio statistic on
some subset, or linear subspace, of the assets.
\item \code{df1} The number of assets.
\item \code{df2} The number of observations.
\item \code{df1.sub} The number of degrees of freedom in the
hedge constraint.
\item \code{drag} The drag term, which is the 'risk free rate' divided by
the maximum risk.
\item \code{ope} The 'observations per epoch'.
\item \code{epoch} The string name of the 'epoch'.
}

For the most part, this constructor should \emph{not} be called directly,
rather \code{\link{as.del_sropt}} should be called instead to compute the
needed statistics.
}
\note{
\bold{WARNING:} This function is not well tested, may contain errors, may change in the
next package update. Take caution.

2FIX: allow rownames?
}
\examples{
# roll your own.
ope <- 253

set.seed(as.integer(charToRaw("be determinstic")))
n.stock <- 10
X <- matrix(rnorm(1000*n.stock),nrow=1000)
Sigma <- cov(X)
mu <- colMeans(X)
w <- solve(Sigma,mu)
z <- t(mu) \%*\% w
n.sub <- 6
w.sub <- solve(Sigma[1:n.sub,1:n.sub],mu[1:n.sub])
z.sub <- t(mu[1:n.sub]) \%*\% w.sub
df1.sub <- n.stock - n.sub

roll.own <- del_sropt(z.s=z,z.sub=z.sub,df1=10,df2=1000,
 df1.sub=df1.sub,ope=ope)
print(roll.own)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\seealso{
\code{\link{reannualize}}

\code{\link{as.del_sropt}}

Other del_sropt: \code{\link{as.del_sropt}},
  \code{\link{as.del_sropt.default}},
  \code{\link{as.del_sropt.xts}};
  \code{\link{is.del_sropt}}
}
\keyword{univar}

