% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackstraw.R
\name{PCASigGenes}
\alias{PCASigGenes}
\title{Significant genes from a PCA}
\usage{
PCASigGenes(object, pcs.use, pval.cut = 0.1, use.full = FALSE,
  max.per.pc = NULL)
}
\arguments{
\item{object}{Seurat object}

\item{pcs.use}{PCS to use.}

\item{pval.cut}{P-value cutoff}

\item{use.full}{Use the full list of genes (from the projected PCA). Assumes
that ProjectPCA has been run. Currently, must be set to FALSE.}

\item{max.per.pc}{Maximum number of genes to return per PC. Used to avoid genes from one PC dominating the entire analysis.}
}
\value{
A vector of genes whose p-values are statistically significant for
at least one of the given PCs.
}
\description{
Returns a set of genes, based on the JackStraw analysis, that have
statistically significant associations with a set of PCs.
}
\examples{
PCASigGenes(pbmc_small, pcs.use = 1:2)

}
