% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_validation.R
\name{ValidateSpecificClusters}
\alias{ValidateSpecificClusters}
\title{Specific Cluster Validation}
\usage{
ValidateSpecificClusters(object, cluster1 = NULL, cluster2 = 1,
  pc.use = 2, top.genes = 30, acc.cutoff = 0.9)
}
\arguments{
\item{object}{Seurat object}

\item{cluster1}{First cluster to check classification}

\item{cluster2}{Second cluster to check with classification}

\item{pc.use}{Which PCs to use for model construction}

\item{top.genes}{Use the top X genes for model construction}

\item{acc.cutoff}{Accuracy cutoff for classifier}
}
\value{
Returns a Seurat object, object@ident has been updated with
new cluster info
}
\description{
Methods for validating the legitimacy of two specific clusters using
classification. SVMs are used as the basis for the classification.
Merging is done based on the connectivity from an SNN graph.
}
\examples{
\dontrun{
pbmc_small
pbmc_small <- FindClusters(object = pbmc_small, reduction.type = "pca",
                           dims.use = 1:10, resolution = 1.1, save.SNN = TRUE)
pbmc_small <- ValidateSpecificClusters(pbmc_small, cluster1 = 1,
                                       cluster2 = 2,  pc.use = 1:10)
}

}
