% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{DimPlot}
\alias{DimPlot}
\title{Dimensional reduction plot}
\usage{
DimPlot(object, reduction.use = "pca", dim.1 = 1, dim.2 = 2,
  cells.use = NULL, pt.size = 1, do.return = FALSE, do.bare = FALSE,
  cols.use = NULL, group.by = "ident", pt.shape = NULL,
  do.hover = FALSE, data.hover = "ident", do.identify = FALSE,
  do.label = FALSE, label.size = 4, no.legend = FALSE, no.axes = FALSE,
  dark.theme = FALSE, plot.order = NULL, plot.title = NULL, ...)
}
\arguments{
\item{object}{Seurat object}

\item{reduction.use}{Which dimensionality reduction to use. Default is
"pca", can also be "tsne", or "ica", assuming these are precomputed.}

\item{dim.1}{Dimension for x-axis (default 1)}

\item{dim.2}{Dimension for y-axis (default 2)}

\item{cells.use}{Vector of cells to plot (default is all cells)}

\item{pt.size}{Adjust point size for plotting}

\item{do.return}{Return a ggplot2 object (default : FALSE)}

\item{do.bare}{Do only minimal formatting (default : FALSE)}

\item{cols.use}{Vector of colors, each color corresponds to an identity
class. By default, ggplot assigns colors.}

\item{group.by}{Group (color) cells in different ways (for example, orig.ident)}

\item{pt.shape}{If NULL, all points are circles (default). You can specify any
cell attribute (that can be pulled with FetchData) allowing for both different colors and
different shapes on cells.}

\item{do.hover}{Enable hovering over points to view information}

\item{data.hover}{Data to add to the hover, pass a character vector of features to add. Defaults to cell name and ident. Pass 'NULL' to clear extra information.}

\item{do.identify}{Opens a locator session to identify clusters of cells.}

\item{do.label}{Whether to label the clusters}

\item{label.size}{Sets size of labels}

\item{no.legend}{Setting to TRUE will remove the legend}

\item{no.axes}{Setting to TRUE will remove the axes}

\item{dark.theme}{Use a dark theme for the plot}

\item{plot.order}{Specify the order of plotting for the idents. This can be
useful for crowded plots if points of interest are being buried. Provide
either a full list of valid idents or a subset to be plotted last (on top).}

\item{plot.title}{Title for plot}

\item{...}{Extra parameters to FeatureLocator for do.identify = TRUE}
}
\value{
If do.return==TRUE, returns a ggplot2 object. Otherwise, only
graphical output.
}
\description{
Graphs the output of a dimensional reduction technique (PCA by default).
Cells are colored by their identity class.
}
\examples{
DimPlot(object = pbmc_small)

}
\seealso{
\code{FeatureLocator}
}
