% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{FindMarkersNode}
\alias{FindMarkersNode}
\title{Gene expression markers of identity classes defined by a phylogenetic clade}
\usage{
FindMarkersNode(object, node, tree.use = NULL, genes.use = NULL,
  logfc.threshold = 0.25, test.use = "bimod", assay.type = "RNA", ...)
}
\arguments{
\item{object}{Seurat object}

\item{node}{The node in the phylogenetic tree to use as a branch point}

\item{tree.use}{Can optionally pass the tree to be used. Default uses the tree in object@cluster.tree}

\item{genes.use}{Genes to test. Default is to use all genes}

\item{logfc.threshold}{Limit testing to genes which show, on average, at least
X-fold difference (log-scale) between the two groups of cells. Default is 0.25
Increasing logfc.threshold speeds up the function, but can miss weaker signals.}

\item{test.use}{Denotes which test to use. Available options are:
\itemize{
 \item{"wilcox"} : Wilcoxon rank sum test (default)
 \item{"bimod"} : Likelihood-ratio test for single cell gene expression,
 (McDavid et al., Bioinformatics, 2013)
 \item{"roc"} : Standard AUC classifier
 \item{"t"} : Student's t-test
 \item{"tobit"} : Tobit-test for differential gene expression (Trapnell et
 al., Nature Biotech, 2014)
 \item{"poisson"} : Likelihood ratio test assuming an underlying poisson
  distribution. Use only for UMI-based datasets
 \item{"negbinom"} :  Likelihood ratio test assuming an underlying negative
 binomial distribution. Use only for UMI-based datasets
 \item{"MAST} : GLM-framework that treates cellular detection rate as a
 covariate (Finak et al, Genome Biology, 2015)
 \item{"DESeq2} : DE based on a model using the negative binomial
 distribution (Love et al, Genome Biology, 2014)
}}

\item{assay.type}{Type of assay to fetch data for (default is RNA)}

\item{...}{Additional arguments passed to FindMarkers}
}
\value{
Matrix containing a ranked list of putative markers, and associated
statistics (p-values, ROC score, etc.)
}
\description{
Finds markers (differentially expressed genes) based on a branching point (node) in
the phylogenetic tree. Markers that define clusters in the left branch are positive markers.
Markers that define the right branch are negative markers.
}
\examples{
FindMarkersNode(pbmc_small, 5)

}
