% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{Read10X}
\alias{Read10X}
\title{Load in data from 10X}
\usage{
Read10X(data.dir = NULL)
}
\arguments{
\item{data.dir}{Directory containing the matrix.mtx, genes.tsv, and barcodes.tsv
files provided by 10X. A vector or named vector can be given in order to load
several data directories. If a named vector is given, the cell barcode names
will be prefixed with the name.}
}
\value{
Returns a sparse matrix with rows and columns labeled
}
\description{
Enables easy loading of sparse data matrices provided by 10X genomics.
}
\examples{
\dontrun{
data_dir <- 'path/to/data/directory'
list.files(data_dir) # Should show barcodes.tsv, genes.tsv, and matrix.mtx
expression_matrix <- Read10X(data.dir = data_dir)
seurat_object = CreateSeuratObject(raw.data = expression_matrix)
}

}
