% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qhc.R
\name{qhc}
\alias{qhc}
\title{Quantile of Higher Criticism statitics under the null hypothesis.}
\usage{
qhc(p, M, k0, k1, onesided = FALSE, LS = F, ZW = F)
}
\arguments{
\item{p}{-  a scalar left probability that defines the quantile.}

\item{M}{- correlation matrix of input statistics (of the input p-values).}

\item{k0}{- search range starts from the k0th smallest p-value.}

\item{k1}{- search range ends at the k1th smallest p-value.}

\item{onesided}{- TRUE if the input p-values are one-sided.}

\item{LS}{- if LS = T, then method of Li and Siegmund (2015) will be implemented.When n and q is very large, approximation method is prefered.}

\item{ZW}{- if ZW = T, then approximation method of Zhang and Wu will be implemented.}
}
\value{
Quantile of HC statistics.
}
\description{
Quantile of Higher Criticism statitics under the null hypothesis.
}
\examples{
## The 0.05 critical value of HC statistic when n = 10:
qhc(p=.95, M=diag(10), k0=1, k1=5, onesided=FALSE)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal Signal-Detection Methods In Finite Cases", submitted.

2. Donoho, David; Jin, Jiashun. "Higher criticism for detecting sparse heterogeneous mixtures". Annals of Statistics 32 (2004).

3. Li, Jian; Siegmund, David. "Higher criticism: p-values and criticism". Annals of Statistics 43 (2015).
}
\seealso{
\code{\link{stat.hc}} for the definition of the statistic.
}
