% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_network_sim}
\alias{plot_network_sim}
\title{Plot the similarity between two networks}
\usage{
plot_network_sim(network_1, network_2, compare_graph = NULL, ...)
}
\arguments{
\item{network_1}{A weighted 'network' or 'matrix' object.}

\item{network_2}{A weighted 'network' or 'matrix' object.}

\item{compare_graph}{The plot of another network to use for comparison.}

\item{...}{Additional arguments passed to \code{\link{plot_network}}.}
}
\value{
Creates a plot of the network and returns a graph object.
The graph object can be passed back into a future call of
\code{\link{plot_network}}, \code{\link{plot_network_diff}} or
\code{\link{plot_network_sim}} through the \code{compare_edge} argument,
which will setup the plot for easier  comparison between the old graph and
the graph of \code{network}.
}
\description{
This function plots the similarity of connections between two networks.
Both networks must be weighted. The width of each edge corresponds to
the strength of similarity and is calculated by sqrt(abs((s1 + s2)s1s2)),
where s1 and s2 are the weights for a particular
connection in \code{network_1} and \code{network_2}, respectively
}
\examples{
# Create two networks, the second being a perturbation of the first.
nw1 <- random_network(20)
nw2 <- perturb_network(nw1, n_nodes = 5)
nw1 <- gen_partial_correlations(nw1)
nw2 <- gen_partial_correlations(nw2)
# Can compare networks by plotting each using the same layout.
g <- plot(nw1)
plot(nw2, g)
# Or, plot the differential network or similarity network
plot_network_diff(nw1, nw2, g)
plot_network_sim(nw1, nw2, g)
# Note the behavior when both networks are the same.
plot_network_diff(nw1, nw1, g) # No differences produces an empty network
plot_network_sim(nw1, nw1, g) # Edge widths are still scaled by connection strength.
}
