% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{create_module_from_association_matrix}
\alias{create_module_from_association_matrix}
\title{Create a module from an association matrix}
\usage{
create_module_from_association_matrix(
  association_matrix,
  nodes = NULL,
  module_name = NULL
)
}
\arguments{
\item{association_matrix}{The association matrix used to create the module.}

\item{nodes}{A numeric vector indicating which nodes in the network are
contained in this module.}

\item{module_name}{(optional) Character string specifying the name of the
module. If \code{NULL}, the module will be unnamed.}
}
\value{
A 'network_module' object.
}
\description{
The edge weights in the module will be set to the corresponding values
in the association matrix. The edges are undirected, and only the lower
triangle of the matrix is considered. See \code{\link{set_module_weights}}
for more details.
}
\examples{
nw <- random_network(10)
nw <- gen_partial_correlations(nw)
assoc_mat <- get_association_matrix(nw)
create_module_from_association_matrix(assoc_mat)
}
