% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngrams.R
\name{ngram_tokenize}
\alias{ngram_tokenize}
\title{N-gram tokenizer}
\usage{
ngram_tokenize(x, char = FALSE, ngmin = 1, ngmax = 3)
}
\arguments{
\item{x}{input string}

\item{char}{boolean value specifying whether to use character (char = TRUE) 
or word n-grams (char = FALSE, default)}

\item{ngmin}{integer giving the minimum order of n-gram (default: 1)}

\item{ngmax}{integer giving the maximum order of n-gram (default: 3)}
}
\description{
A tokenizer for use with a document-term matrix from the tm package. Supports 
both character and word ngrams, including own wrapper to handle non-Latin 
encodings
}
\examples{
library(tm)
en <- c("Romeo loves Juliet", "Romeo loves a girl")
en.corpus <- VCorpus(VectorSource(en))
tdm <- TermDocumentMatrix(en.corpus, 
                          control=list(wordLengths=c(1,Inf), 
                                       tokenize=function(x) ngram_tokenize(x, char=TRUE, 
                                                                           ngmin=3, ngmax=3)))
inspect(tdm)

ch <- c("abab", "aabb")
ch.corpus <- VCorpus(VectorSource(ch))
tdm <- TermDocumentMatrix(ch.corpus, 
                          control=list(wordLengths=c(1,Inf), 
                                       tokenize=function(x) ngram_tokenize(x, char=TRUE, 
                                                                           ngmin=1, ngmax=2)))
inspect(tdm)
}
\keyword{preprocessing}
