% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mixt.fit.init.R
\name{Mixt.fit.init}
\alias{Mixt.fit.init}
\title{Initialization for the EM-based algorithms}
\usage{
Mixt.fit.init(X, k = 1:3, density, nstartR = 100, ncores = 1, verbose = FALSE)
}
\arguments{
\item{X}{A data matrix with \code{n} rows and \code{d} columns, being \code{n} the number of data points and \code{d} the data the dimensionality.}

\item{k}{An integer or a vector indicating the number of groups of the models.}

\item{density}{A character indicating the density of the mixture components. Possible values are: "MSEN" or "MTIN".}

\item{nstartR}{An integer specifying the number of random starts to be considered.}

\item{ncores}{A positive integer indicating the number of cores used for running in parallel.}

\item{verbose}{A logical indicating whether the running output should be displayed.}
}
\value{
\item{init}{A list of objects to be used by the \code{Mixt.fit()} function.}
}
\description{
Runs the initialization of the EM-based algorithms used for fitting parsimonious mixtures of MSEN or MTIN distributions.
Parallel computing is implemented and highly recommended for a faster calculation.
}
\examples{
set.seed(1234)
n <- 50
k <- 2
Pi <- c(0.5, 0.5)
mu <- matrix(c(0, 0, 4, 5), 2, 2)
cov.model <- "EEE"
lambda <- c(0.5, 0.5)
delta <- c(0.7, 0.7)
gamma <- c(2.62, 2.62)
theta <- c(0.1, 0.1)
density <- "MSEN"
data <- rMixt(n, k, Pi, mu, cov.model, lambda, delta, gamma, theta, density)

X <- data$X
nstartR <- 1
init.par <- Mixt.fit.init(X, k, density, nstartR)
}
