% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equate.R
\name{equate}
\alias{equate}
\title{Equate Group Responses}
\usage{
equate(rmatA, rmatB)
}
\arguments{
\item{rmatA}{Binary matrix.
A \link[SemNetCleaner]{textcleaner} filtered response matrix
for binary matrix A}

\item{rmatB}{Binary matrix. 
A \link[SemNetCleaner]{textcleaner} filtered response matrix
for binary matrix B}
}
\value{
A list containing binary matrices that have matching column
names (matching response):

\item{rmatA}{Binary matrix with matched responses for \code{rmatA}}

\item{rmatB}{Binary matrix with matched responses for \code{rmatB}}
}
\description{
In general, this function serves as a wrapper for
\code{\link[SemNetCleaner]{equate.multi}}. This function equates the
responses between two binary response matrices (e.g., two groups)
by only keeping the column names that match between both matrices.
}
\examples{
# Toy example
raw <- open.animals[c(1:10),-c(1,2)]

# Clean and prepocess data
clean <- textcleaner(raw, partBY = "row", dictionary = "animals")

# Obtain binary data
bin <- clean$binary

# Finalize mat1
mat1 <- finalize(bin[c(1:5),])

# Finalize mat2
mat2 <- finalize(bin[c(6:10),])


# Equate mat1 and mat1
eq <- equate(mat1, mat2)

# Obtain respective equated response matrices
eq.mat1 <- eq$mat1
eq.mat2 <- eq$mat2

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
