% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converge.R
\name{converge}
\alias{converge}
\title{Converge Responses}
\usage{
converge(rmat, word, replace)
}
\arguments{
\item{rmat}{Binary matrix.
A \link[SemNetCleaner]{textcleaner} filtered response matrix}

\item{word}{Must be column name (characters).
The column name (or number) that be merged \emph{into}.
This column will \emph{remain} in the matrix}

\item{replace}{Must be column name (characters).
The column name (or number) that should be merged
with the \code{word} column.
This column will be \emph{removed} from the matrix}
}
\value{
The response matrix with the \code{word} column merged
and the \code{replace} column removed
}
\description{
Merge a column of binarized response data with another
}
\examples{
#converge "kitten" into response of "cat"
rmat <- converge(rmat,"cat","kitten")

#"cat" remains will "kitten" responses are merged into
#"cat" and "kitten" is removed

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
