#' Autoboost lasso diabetes first order.
#'
#' Result of autoboost analysis of diabetes data from \cite{lars} package with lasso
#' and first order model
#'
#' @docType data
#' @format A numerical matrix frame with 13 rows and 10 variables with attributes.
"autoboost.res.x"
#> [1] "autoboost.res.x"

#' Autoboost lasso diabetes second order.
#'
#' Result of autoboost analysis of diabetes data from \cite{lars} package with lasso
#' and second order model
#'
#' @docType data
#' @format A numerical matrix frame with 13 rows and 64 variables with attributes.
"autoboost.res.x2"
#> [1] "autoboost.res.x2"

#' Autoboost adaptative lasso diabetes first order.
#'
#' Result of autoboost analysis of diabetes data from \cite{lars} package with adaptative
#' lasso and first order model
#'
#' @docType data
#' @format A numerical matrix frame with 13 rows and 10 variables with attributes.
"autoboost.res.x.adapt"
#> [1] "autoboost.res.x.adapt"

#' Autoboost adaptative lasso diabetes second order.
#'
#' Result of autoboost analysis of diabetes data from \cite{lars} package with adaptative
#' lasso and second order model
#'
#' @docType data
#' @format A numerical matrix frame with 13 rows and 64 variables with attributes.
"autoboost.res.x2.adapt"
#> [1] "autoboost.res.x2.adapt"

#' Fastboost lasso diabetes first order.
#'
#' Result of fastboost analysis of diabetes data from \cite{lars} package with lasso
#' and first order model
#'
#' @docType data
#' @format A numerical matrix frame with 13 rows and 10 variables with attributes.
"fastboost.res.x"
#> [1] "fastboost.res.x"

#' Fastboost lasso diabetes second order.
#'
#' Result of fastboost analysis of diabetes data from \cite{lars} package with lasso
#' and second order model
#'
#' @docType data
#' @format A numerical matrix frame with 13 rows and 64 variables with attributes.
"fastboost.res.x2"
#> [1] "fastboost.res.x2"

#' Fastboost adaptative lasso diabetes first order.
#'
#' Result of fastboost analysis of diabetes data from \cite{lars} package with adaptative
#' lasso and first order model
#'
#' @docType data
#' @format A numerical matrix frame with 13 rows and 10 variables with attributes.
"fastboost.res.x.adapt"
#> [1] "fastboost.res.x.adapt"

#' Fastboost adaptative lasso diabetes second order.
#'
#' Result of fastboost analysis of diabetes data from \cite{lars} package with adaptative
#' lasso and second order model
#'
#' @docType data
#' @format A numerical matrix frame with 13 rows and 64 variables with attributes.
"fastboost.res.x2.adapt"
#> [1] "fastboost.res.x2.adapt"


#' Simulations for reverse-engineering
#'
#' Result of fastboost analysis applied to biological network reverse engineering
#'
#' @docType data
#' @format A numerical matrix frame with 100 rows and 200 variables or a numerical vector of length 100.
#' @rdname reverse
#' @name results_simuls_reverse_engineering_v3
#' @docType data
NULL
#' @rdname reverse
"test.seq_C"
#> [1] "test.seq_C"
#' @rdname reverse
"test.seq_PL"
#> [1] "test.seq_PL"
#' @rdname reverse
"test.seq_PL2"
#> [1] "test.seq_PL2"
#' @rdname reverse
"test.seq_PL2_W"
#> [1] "test.seq_PL2_W"
#' @rdname reverse
"test.seq_PL2_tW"
#> [1] "test.seq_PL2_tW"
#' @rdname reverse
"test.seq_PSel"
#> [1] "test.seq_PSel"
#' @rdname reverse
"test.seq_PSel.5"
#> [1] "test.seq_PSel.5"
#' @rdname reverse
"test.seq_PSel.e2"
#> [1] "test.seq_PSel.e2"
#' @rdname reverse
"test.seq_PSel.5.e2"
#> [1] "test.seq_PSel.5.e2"
#' @rdname reverse
"test.seq_PSel_W"
#> [1] "test.seq_PSel_W"
#' @rdname reverse
"test.seq_robust"
#> [1] "test.seq_robust"
#' @rdname reverse
"test.seq_PB"
#> [1] "test.seq_PB"
#' @rdname reverse
"test.seq_PB_095_075"
#> [1] "test.seq_PB_095_075"
#' @rdname reverse
"test.seq_PB_075_075"
#> [1] "test.seq_PB_075_075"
#' @rdname reverse
"test.seq_PB_W"
#> [1] "test.seq_PB_W"
#' @rdname reverse
"sensitivity_C"
#> [1] "sensitivity_C"
#' @rdname reverse
"sensitivity_PL"
#> [1] "sensitivity_PL"
#' @rdname reverse
"sensitivity_PL2"
#> [1] "sensitivity_PL2"
#' @rdname reverse
"sensitivity_PL2_W"
#> [1] "sensitivity_PL2_W"
#' @rdname reverse
"sensitivity_PL2_tW"
#> [1] "sensitivity_PL2_tW"
#' @rdname reverse
"sensitivity_PSel"
#> [1] "sensitivity_PSel"
#' @rdname reverse
"sensitivity_PSel.5"
#> [1] "sensitivity_PSel.5"
#' @rdname reverse
"sensitivity_PSel.e2"
#> [1] "sensitivity_PSel.e2"
#' @rdname reverse
"sensitivity_PSel.5.e2"
#> [1] "sensitivity_PSel.5.e2"
#' @rdname reverse
"sensitivity_PSel_W"
#> [1] "sensitivity_PSel_W"
#' @rdname reverse
"sensitivity_robust"
#> [1] "sensitivity_robust"
#' @rdname reverse
"sensitivity_PB"
#> [1] "sensitivity_PB"
#' @rdname reverse
"sensitivity_PB_095_075"
#> [1] "sensitivity_PB_095_075"
#' @rdname reverse
"sensitivity_PB_075_075"
#> [1] "sensitivity_PB_075_075"
#' @rdname reverse
"sensitivity_PB_W"
#> [1] "sensitivity_PB_W"
#' @rdname reverse
"predictive_positive_value_C"
#> [1] "predictive_positive_value_C"
#' @rdname reverse
"predictive_positive_value_PL"
#> [1] "predictive_positive_value_PL"
#' @rdname reverse
"predictive_positive_value_PL2"
#> [1] "predictive_positive_value_PL2"
#' @rdname reverse
"predictive_positive_value_PL2_W"
#> [1] "predictive_positive_value_PL2_W"
#' @rdname reverse
"predictive_positive_value_PL2_tW"
#> [1] "predictive_positive_value_PL2_tW"
#' @rdname reverse
"predictive_positive_value_PSel"
#> [1] "predictive_positive_value_PSel"
#' @rdname reverse
"predictive_positive_value_PSel.5"
#> [1] "predictive_positive_value_PSel.5"
#' @rdname reverse
"predictive_positive_value_PSel.e2"
#> [1] "predictive_positive_value_PSel.e2"
#' @rdname reverse
"predictive_positive_value_PSel.5.e2"
#> [1] "predictive_positive_value_PSel.5.e2"
#' @rdname reverse
"predictive_positive_value_PSel_W"
#> [1] "predictive_positive_value_PSel_W"
#' @rdname reverse
"predictive_positive_value_robust"
#> [1] "predictive_positive_value_robust"
#' @rdname reverse
"predictive_positive_value_PB"
#> [1] "predictive_positive_value_PB"
#' @rdname reverse
"predictive_positive_value_PB_095_075"
#> [1] "predictive_positive_value_PB_095_075"
#' @rdname reverse
"predictive_positive_value_PB_075_075"
#> [1] "predictive_positive_value_PB_075_075"
#' @rdname reverse
"predictive_positive_value_PB_W"
#> [1] "predictive_positive_value_PB_W"
#' @rdname reverse
"F_score_C"
#> [1] "F_score_C"
#' @rdname reverse
"F_score_PL"
#> [1] "F_score_PL"
#' @rdname reverse
"F_score_PL2"
#> [1] "F_score_PL2"
#' @rdname reverse
"F_score_PL2_W"
#> [1] "F_score_PL2_W"
#' @rdname reverse
"F_score_PL2_tW"
#> [1] "F_score_PL2_tW"
#' @rdname reverse
"F_score_PSel"
#> [1] "F_score_PSel"
#' @rdname reverse
"F_score_PSel.5"
#> [1] "F_score_PSel.5"
#' @rdname reverse
"F_score_PSel.e2"
#> [1] "F_score_PSel.e2"
#' @rdname reverse
"F_score_PSel.5.e2"
#> [1] "F_score_PSel.5.e2"
#' @rdname reverse
"F_score_PSel_W"
#> [1] "F_score_PSel_W"
#' @rdname reverse
"F_score_robust"
#> [1] "F_score_robust"
#' @rdname reverse
"F_score_PB"
#> [1] "F_score_PB"
#' @rdname reverse
"F_score_PB_095_075"
#> [1] "F_score_PB_095_075"
#' @rdname reverse
"F_score_PB_075_075"
#> [1] "F_score_PB_075_075"
#' @rdname reverse
"F_score_PB_W"
#> [1] "F_score_PB_W"
#' @rdname reverse
"nv_C"
#> [1] "nv_C"
#' @rdname reverse
"nv_PL"
#> [1] "nv_PL"
#' @rdname reverse
"nv_PL2"
#> [1] "nv_PL2"
#' @rdname reverse
"nv_PL2_W"
#> [1] "nv_PL2_W"
#' @rdname reverse
"nv_PL2_tW"
#> [1] "nv_PL2_tW"
#' @rdname reverse
"nv_PSel"
#> [1] "nv_PSel"
#' @rdname reverse
"nv_PSel.5"
#> [1] "nv_PSel.5"
#' @rdname reverse
"nv_PSel.e2"
#> [1] "nv_PSel.e2"
#' @rdname reverse
"nv_PSel.5.e2"
#> [1] "nv_PSel.5.e2"
#' @rdname reverse
"nv_PSel_W"
#> [1] "nv_PSel_W"
#' @rdname reverse
"nv_robust"
#> [1] "nv_robust"
#' @rdname reverse
"nv_PB"
#> [1] "nv_PB"
#' @rdname reverse
"nv_PB_095_075"
#> [1] "nv_PB_095_075"
#' @rdname reverse
"nv_PB_075_075"
#> [1] "nv_PB_075_075"
#' @rdname reverse
"nv_PB_W"
#> [1] "nv_PB_W"

#' Confidence indices
#'
#' Result for confidence indices derivation using the Cascade package
#'
#' @docType data
#' @format A \code{network.confidence} object with four slots :
#' \describe{
#'   \item{network.confidence}{The confidence matrix}
#'   \item{name}{Names of the variables (genes)}
#'   \item{F}{F array, see Cascade for more details}
#'   \item{time_pt}{Repeated measurements}
#'   \item{cv.subjects}{Logical. Was crossvalidation carried out subjectwise?}
#' }
#'
#' @name Cascade_confidence
#' @rdname Cascade_confidence
"net_confidence"
#> [1] "net_confidence"
#' @rdname Cascade_confidence
"net_confidence_.5"
#> [1] "net_confidence_.5"
#' @rdname Cascade_confidence
"net_confidence_thr"
#> [1] "net_confidence_thr"

#' Simulated Cascade network and inference
#'
#' Result for the reverse engineering of a simulated Cascade network
#' @docType data
#' @format Three objects :
#' \describe{
#'   \item{M}{Simulated microarray}
#'   \item{Net}{Simulated network}
#'   \item{Net_inf_C}{Inferred network}
#' }
#' @name Cascade_example
#' @rdname Cascade_example
"M"
#> [1] "M"
#' @rdname Cascade_example
"Net"
#> [1] "Net"
#' @rdname Cascade_example
"Net_inf_C"
#> [1] "Net_inf_C"
