% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SILO.R
\name{SILODoubleMass}
\alias{SILODoubleMass}
\title{Plot double mass curves of each rainfall site against each other}
\usage{
SILODoubleMass(SILO, filename = NULL, plotsperpage = 4)
}
\arguments{
\item{SILO}{a list of sites with SILO data, as created by SILOLoad()}

\item{filename}{optional, filename to write the plot to, including extension. Filename can include full path or sub folders.}

\item{plotsperpage}{optional, number of plots to output per element of the list returned. Defaults to 4}
}
\value{
a list of ggplot objects that plot of the double mass curves of each station in the SILO list against each other. The double mass plot is on the bottom diagonal, and the slope of the line for each case in the upper diagonal. Each list element contains plotsperpage (default to 4) double mass plots, to allow them to be plotted on multiple pages
}
\description{
Plot double mass curves of each rainfall site against each other
}
\examples{
 
\dontrun{
X<-SILOLoad(c("24001","24002","24003"),path="./SWTools/extdata")
p<-SILODoubleMass(X)
}
}
