% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitINLA.R
\name{fitINLA}
\alias{fitINLA}
\title{Fit INLA models to direct estimators.}
\usage{
fitINLA(data, Amat, geo, formula = NULL, year_names, na.rm = TRUE,
  redo.prior = FALSE, priors = NULL, useHyper = FALSE, a.iid = NULL,
  b.iid = NULL, a.rw1 = NULL, b.rw1 = NULL, a.rw2 = NULL,
  b.rw2 = NULL, a.icar = NULL, b.icar = NULL)
}
\arguments{
\item{data}{Combined dataset}

\item{Amat}{Adjacency matrix for the regions}

\item{geo}{Geo file}

\item{formula}{INLA formula. Defaults to RW2, ICAR, IID time, IID, region, IID survey effect, IID time-region interaction, IID survey-region interaction, and IID survey-time-region interaction.}

\item{year_names}{string vector of year names}

\item{na.rm}{Logical indicator of whether to remove rows with NA values in the data. Default set to TRUE.}

\item{redo.prior}{Logical indicator of whether to re-estimate hyper parameters}

\item{priors}{priors from simhyper}

\item{useHyper}{option to manually set all hyper priors}

\item{a.iid}{hyper parameter for i.i.d random effects, only need if \code{useHyper = TRUE}}

\item{b.iid}{hyper parameter for i.i.d random effects, only need if \code{useHyper = TRUE}}

\item{a.rw1}{hyper parameter for RW1 random effects, only need if \code{useHyper = TRUE}}

\item{b.rw1}{hyper parameter for RW1 random effects, only need if \code{useHyper = TRUE}}

\item{a.rw2}{hyper parameter for RW2 random effects, only need if \code{useHyper = TRUE}}

\item{b.rw2}{hyper parameter for RW2 random effects, only need if \code{useHyper = TRUE}}

\item{a.icar}{hyper parameter for ICAR random effects, only need if \code{useHyper = TRUE}}

\item{b.icar}{hyper parameter for ICAR random effects, only need if \code{useHyper = TRUE}}
}
\value{
INLA model fit using the provided formula, country summary data, and geographic data
}
\description{
Fit INLA models to direct estimators.
}
\examples{
\dontrun{
data(Uganda)
data(UgandaMap)
geo <- UgandaMap$geo
mat <- UgandaMap$Amat
years <- c("85-89", "90-94", "95-99", "00-04", "05-09", "10-14")

# Get direct estimates
u5m <- countrySummary_mult(births = Uganda, years = years, idVar = "id", 
regionVar = "region", timeVar = "time", clusterVar = "~clustid+id", 
ageVar = "age", weightsVar = "weights", geo.recode = NULL)

# Get hyper priors
priors <- simhyper(R = 2, nsamp = 1e+05, nsamp.check = 5000, Amat = mat)

# Fit INLA models
data <- data[data$region \%in\% c("central","eastern","northern","western"),]
inla_model <- fitINLA(data = data, geo = geo, Amat = mat, year_names = years, priors = priors)
}

}
\seealso{
\code{\link{countrySummary}}
}
