% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_in_one_workflow_fun.R
\name{STRMPSWorkflow}
\alias{STRMPSWorkflow}
\title{Workflow function}
\usage{
STRMPSWorkflow(input, output = NULL, continueCheckpoint = NULL,
  control = workflow.control())
}
\arguments{
\item{input}{A path to a \code{.fastq}-file.}

\item{output}{A directory where output-files are stored.}

\item{continueCheckpoint}{Choose a checkpoint to continue from in the workflow. If NULL the function will run the entire workflow.}

\item{control}{Function controlling non-crucial parameters and other control functions.}
}
\value{
If 'output' not provided the function simply returns the stringCoverageList-object.
If an output is provided the function will store ALL created objects at the output-path, i.e. nothing is returned.
}
\description{
The function takes an input file and performs all preliminary analyses.
The function creates a series of objects which can be further analysed.
An output folder can be provided to store the objects as \code{.RData}-files.
}
\examples{
readPath <- system.file('extdata', 'sampleSequences.fastq', package = 'STRMPS')
\donttest{
STRMPSWorkflow(readPath,
               control = workflow.control(restrictType = "Autosomal",
                                          numberOfThreads = 1)
               )
}
}
