% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate-rolling.R
\name{estimate_rolling_1RM}
\alias{estimate_rolling_1RM}
\title{Estimate the rolling profile and 1RM}
\usage{
estimate_rolling_1RM(
  weight,
  reps,
  eRIR = 0,
  day_index,
  window = 14,
  estimate_function = estimate_k_1RM,
  ...
)
}
\arguments{
\item{weight}{Weight used}

\item{reps}{Number of repetitions done}

\item{eRIR}{Subjective estimation of reps-in-reserve (eRIR)}

\item{day_index}{Day index used to estimate rolling window}

\item{window}{Width of the rolling window. Default is 14}

\item{estimate_function}{Estimation function to be used. Default is
\code{\link{estimate_k_1RM}}}

\item{...}{Forwarded to \code{estimate_function} function}
}
\value{
Data frame with day index and coefficients returned by the \code{estimate_function} function
}
\description{
Estimate the rolling profile and 1RM
}
\examples{
estimate_rolling_1RM(
  weight = strength_training_log$weight,
  reps = strength_training_log$reps,
  eRIR = strength_training_log$eRIR,
  day_index = strength_training_log$day,
  window = 10,
  estimate_function = estimate_k_1RM_quantile,
  tau = 0.9)
}
