% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EntropyRegularizedLogisticRegression.R
\name{EntropyRegularizedLogisticRegressionSSLR}
\alias{EntropyRegularizedLogisticRegressionSSLR}
\title{General Interface for EntropyRegularizedLogisticRegression model}
\usage{
EntropyRegularizedLogisticRegressionSSLR(
  lambda = 0,
  lambda_entropy = 1,
  intercept = TRUE,
  init = NA,
  scale = FALSE,
  x_center = FALSE
)
}
\arguments{
\item{lambda}{l2 Regularization}

\item{lambda_entropy}{Weight of the labeled observations compared to the unlabeled observations}

\item{intercept}{logical; Whether an intercept should be included}

\item{init}{Initial parameters for the gradient descent}

\item{scale}{logical; Should the features be normalized? (default: FALSE)}

\item{x_center}{logical;  Should the features be centered?}
}
\description{
model from RSSL package
R Implementation of entropy regularized logistic regression implementation
as proposed by Grandvalet & Bengio (2005). An extra term is added to the objective
function of logistic regression that penalizes the entropy of the posterior measured
on the unlabeled examples.
}
\examples{
library(tidyverse)
library(caret)
library(tidymodels)
library(SSLR)

data(breast)

set.seed(1)
train.index <- createDataPartition(breast$Class, p = .7, list = FALSE)
train <- breast[ train.index,]
test  <- breast[-train.index,]

cls <- which(colnames(breast) == "Class")

#\% LABELED
labeled.index <- createDataPartition(breast$Class, p = .2, list = FALSE)
train[-labeled.index,cls] <- NA


m <- EntropyRegularizedLogisticRegressionSSLR() \%>\% fit(Class ~ ., data = train)


#Accuracy
predict(m,test) \%>\%
  bind_cols(test) \%>\%
  metrics(truth = "Class", estimate = .pred_class)
}
\references{
Grandvalet, Y. & Bengio, Y., 2005. Semi-supervised learning by entropy
minimization. In L. K. Saul, Y. Weiss, & L. Bottou, eds. Advances in Neural Information
Processing Systems 17. Cambridge, MA: MIT Press, pp. 529-536.
}
