% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGOF.R
\name{plotGOF}
\alias{plotGOF}
\title{goodness-of-fit test for SPQR estimator}
\usage{
plotGOF(object, getAll = FALSE)
}
\arguments{
\item{object}{An object of class \code{SPQR}.}

\item{getAll}{If \code{TRUE} and SPQR is fitted with \code{method = "MCMC"}, plots all posterior samples of Q-Q lines. Default: \code{FALSE}.}
}
\value{
A \code{ggplot} object.
}
\description{
Performs a goodness-of-fit test for the estimated conditional probability density function (PDF) using
probability inverse transformation method.
}
\examples{
\donttest{
set.seed(919)
n <- 200
X <- rbinom(n, 1, 0.5)
Y <- rnorm(n, X, 0.8)
control <- list(iter = 200, warmup = 150, thin = 1)
fit <- SPQR(X = X, Y = Y, method = "MCMC", control = control,
            normalize = TRUE, verbose = FALSE)

## Goodness-of-fit test
plotGOF(fit)
}
}
