% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spotRepairMissingValues.R
\name{spotRepairMissingValues}
\alias{spotRepairMissingValues}
\title{Repair Missing Values}
\usage{
spotRepairMissingValues(x, y, spotConfig)
}
\arguments{
\item{x}{data frame of locations}

\item{y}{vector of observations}

\item{spotConfig}{configuration, including spotConfig$seq.na.penalty, spotConfig$seq.predictionModel.func and spotConfig$seq.modelFit

This function may do two things:\cr
1. (optional) If seq.na.penalty is not NULL, a randomForest is trained that tries to learn the dependency of NA-occurrence on x.
This model will later be used to penalize potentially NA-yielding candidate solutions during surrogate-model optimization.\cr
2. More importantly, this function will try to replace any NA value with the predicted mean + variance as determined
with the most recently used Kriging model. In case NA values occur in the initial design, they are simply removed.}
}
\value{
list with elements\cr
\code{x} Locations (If not repaired, locations with NA observations are removed) \cr
\code{y} Observations (If not repaired (due to no available model) the respective NAs are removed)\cr
\code{nafit} Optional fit of a randomForest model (seq.na.penalty set to positive value) that learns the occurrence of NAs for a penalty approach.
}
\description{
In case the target function that is optimized yields NA values (due to implicit constraints),
this function may be used to repair missing values. Currently, it can be used with Kriging
models only.
}
\seealso{
\code{\link{spotPenalizeMissingValues}}, \code{\link{spotRepairMissingValuesCoKriging}}
}

