% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_wrapper.R
\name{Compute_Size_multi}
\alias{Compute_Size_multi}
\title{Compute the sample size of an association study to achieve a target power for multiple E's, using semi-sim.}
\usage{
Compute_Size_multi(
  parameters,
  PowerAim,
  response = "binary",
  covariate,
  mode = "additive",
  alpha = 0.05,
  seed = 123,
  LargePowerApproxi = FALSE,
  searchSizeGamma0 = 100,
  searchSizeBeta0 = 100,
  B = 10000,
  upper.lim.n = 8e+05
)
}
\arguments{
\item{parameters}{A list of parameters that contains all the required parameters in the model. If response is "binary", this list needs to contain "prev" which denotes the prevalence of the disease (or case to control ratio for case-control sampling). If response is continuous, the list needs to contain "traitSD" and "traitMean" which represent the standard deviation and mean of the continuous trait.
If covariate is not "none", a parameter "gammaG" needs to be defined to capture the dependence between the SNP and the covariate (through linear regression model if covariate is continuous, and logistic model if covariate is binary). If covariate is "binary", list needs to contains "pE" that defines the frequency of the covariate. If it is continuous, list needs to contain "muE" and "sigmaE" to define
its mean and standard deviation. The MAF is defined as "pG", with HWE assumed to hold.}

\item{PowerAim}{An numeric value between 0 and 1 that indicates the aimed power of the study.}

\item{response}{A string of either "binary" or "continuous", indicating the type of response/trait variable in the model, by default is "binary"}

\item{covariate}{Same as in Compute_Power_multi.}

\item{mode}{A string of either "additive", "dominant" or "recessive", indicating the genetic mode, by default is "additive".}

\item{alpha}{A numeric value that denotes the significance level used in the study, by default is 0.05.}

\item{seed}{An integer number that indicates the seed used for the simulation to compute the approximate fisher information matrix, by default is 123.}

\item{LargePowerApproxi}{TRUE or FALSE indicates whether to use the large power approximation formula.}

\item{searchSizeGamma0}{The interval radius for the numerical search of gamma0, by default is 8. Setting to higher values may solve some numerical problems at the cost of longer runtime.}

\item{searchSizeBeta0}{The interval radius for the numerical search of beta0, by default is 8. Setting to higher values may solve some numerical problems at the cost of longer runtime.}

\item{B}{An integer number that indicates the number of simulated sample to approximate the fisher information matrix, by default is 10000 (Should only be changed if computation uses semi-simulation method).}

\item{upper.lim.n}{An integer number that indicates the largest sample size to be considered.}
}
\value{
The required sample size.
}
\description{
Compute the sample size of an association study to achieve a target power for multiple E's, using semi-sim.
}
\examples{
parameters <- list(TraitMean = 0.3, TraitSD = 1, pG = 0.2,
betaG = log(1.1), betaE = c(log(1.1), log(1.2)),
muE = 0, sigmaE = 3, gammaG = c(log(2.1), log(2.2)), pE = 0.4)
SPCompute::Compute_Size_multi(parameters, PowerAim = 0.8,
response = "continuous", covariate = c("binary", "continuous"))
}
