% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov1.2015WL.R
\name{cov1.2015WL}
\alias{cov1.2015WL}
\title{One-sample Test for Covariance Matrix by Wu and Li (2015)}
\usage{
cov1.2015WL(X, Sigma0 = diag(ncol(X)), m = 25)
}
\arguments{
\item{X}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{Sigma0}{a \eqn{(p\times p)} given covariance matrix.}

\item{m}{the number of random projections to be applied.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given a multivariate sample \eqn{X} and hypothesized covariance matrix \eqn{\Sigma_0}, it tests
\deqn{H_0 : \Sigma_x = \Sigma_0\quad vs\quad H_1 : \Sigma_x \neq \Sigma_0}
using the procedure by Wu and Li (2015). They proposed to use \eqn{m} number of multiple random projections 
since only a single operation might attenuate the efficacy of the test.
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=3)
cov1.2015WL(smallX) # run the test

\donttest{
## empirical Type 1 error 
##   compare effects of m=5, 10, 50
niter = 1000
rec1  = rep(0,niter) # for m=5
rec2  = rep(0,niter) #     m=10
rec3  = rep(0,niter) #     m=50
for (i in 1:niter){
  X = matrix(rnorm(50*10), ncol=50) # (n,p) = (10,50)
  rec1[i] = ifelse(cov1.2015WL(X, m=5)$p.value < 0.05, 1, 0)
  rec2[i] = ifelse(cov1.2015WL(X, m=10)$p.value < 0.05, 1, 0)
  rec3[i] = ifelse(cov1.2015WL(X, m=50)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'cov1.2015WL'\n","*\n",
"* Type 1 error with m=5   : ",round(sum(rec1/niter),5),"\n",
"* Type 1 error with m=10  : ",round(sum(rec2/niter),5),"\n",
"* Type 1 error with m=50  : ",round(sum(rec3/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{wu_tests_2015}{SHT}
}
\concept{covariance}
