% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plankton_toolbox.R
\name{read_ptbx}
\alias{read_ptbx}
\title{Read a Plankton Toolbox export file}
\usage{
read_ptbx(
  file_path,
  sheet = c("sample_data.txt", "sample_info.txt", "counting_method.txt",
    "Sample summary", "README")
)
}
\arguments{
\item{file_path}{Character. Path to the Excel file.}

\item{sheet}{Character. The name of the sheet to read. Must be one of:
"sample_data.txt", "Sample summary", "sample_info.txt", "counting_method.txt", or "README".
Default is "sample_data.txt".}
}
\value{
A \code{tibble} containing the contents of the selected sheet.
}
\description{
This function reads a sample file exported as an Excel (.xlsx) file from Plankton Toolbox
and extracts data from a specified sheet. The default sheet is "sample_data.txt",
which contains count data.
}
\examples{

# Read the default data sheet
sample_data <- read_ptbx(system.file("extdata/Anholt_E_2024-09-15_0-10m.xlsx",
                                     package = "SHARK4R"))

# Print output
sample_data


# Read a specific sheet
sample_info <- read_ptbx(system.file("extdata/Anholt_E_2024-09-15_0-10m.xlsx",
                                     package = "SHARK4R"),
                         sheet = "sample_info.txt")
# Print output
sample_info

}
\seealso{
\url{https://nordicmicroalgae.org/plankton-toolbox/} for downloading Plankton Toolbox.

\url{https://github.com/planktontoolbox/plankton-toolbox/} for Plankton Toolbox source code.
}
