% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semFit.R
\name{localCI.test}
\alias{localCI.test}
\title{Conditional Independence (CI) local tests of an acyclic graph}
\usage{
localCI.test(graph, data, bap = FALSE, limit = 10000, verbose = TRUE, ...)
}
\arguments{
\item{graph}{A directed graph as an igraph object.}

\item{data}{A data matrix with subjects as rows and variables as
columns.}

\item{bap}{If TRUE, the input graph is trasformend in a BAP, if FALSE
(defult) the input graph is reduced in a DAG.}

\item{limit}{An integer value corresponding to the number of missing
edges of the extracted acyclic graph. Beyond this limit, switch to
Shipley's C-test (Shipley 2000) is enabled to reduce the computational
burden.
By default, \code{limit = 10000}.}

\item{verbose}{If TRUE, LocalCI results will be showed to
screen (default = TRUE).}

\item{...}{Currently ignored.}
}
\value{
A list of three objects: (i) the DAG used to perform the localCI
test (ii) the list of all d-separation tests over missing edges in the
input graph and (iii) the overall Bonferroni's P-value.
}
\description{
P-values of one minimal testable implication (with the
smallest possible conditioning set) is returned per missing edge
given an acyclic graph (DAG or BAP) using the function
\code{\link[dagitty]{impliedConditionalIndependencies}} plus the
function \code{\link[dagitty]{localTests}} from package \code{dagitty}.
Without assuming any particular dependence structure, the p-values of
every CI test, in a DAG (BAP), is then combined using the Bonferroni’s
statistic in an overall test of the fitted model, B = K*min(p1,...,pK),
as reviewed in Vovk & Wang (2020).
}
\examples{

library(huge)
als.npn <- huge.npn(alsData$exprs)

sem <- SEMrun(alsData$graph, als.npn)
B_test <- localCI.test(sem$graph, als.npn, verbose = TRUE)

}
\references{
Vovk V, Wang R (2020). Combining p-values via averaging. Biometrika
107(4): 791-808. <https://doi.org/10.1093/biomet/asaa027>

Shipley B (2000). A new inferential test for path models based on DAGs.
Structural Equation Modeling, 7(2): 206-218.
<https://doi.org/10.1207/S15328007SEM0702_4>
}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
