% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.polygons.r
\name{voronoi.polygons}
\alias{voronoi.polygons}
\title{Calculate Voronoi polygons for a set of points}
\usage{
voronoi.polygons(x, bounding.polygon)
}
\arguments{
\item{x}{A \code{SpatialPoints} or \code{SpatialPointsDataFrame} object}

\item{bounding.polygon}{If present, this is a \code{SpatialPolygons*} object specifying the 
bounding polygon(s) for the Voronoi polygons.  If present, the 
Voronoi polygons from points in \code{x} are clipped to the outside 
bounding polygon of \code{bounding.polygon}.  The outside bounding polygon
is the union of all polygons 
in \code{bounding.polygon}.  If this is not present, the Voronoi polygons
extend to a rectangle outside the range of the input points in all directions
by 10 percent.}
}
\value{
A \code{SpatialPolygonsDataFrame} containing the Voronoi polygons
 (or tessellations) surrounding the points in \code{x}. Attributes of the 
 output polygons are: 
 \itemize{
   \item x : the horizontal coordinate of the tessellation's defining point
   \item y : the vertical coordinate of the tessellation's defining point
   \item area : area of tessellation, in units of \code{x}'s projection.
 }
}
\description{
Calculate Voronoi polygons (or tessellations) from a 
 \code{SpatialPoints*} object
}
\details{
This is a convenience routine for the 
\code{deldir} function.  The hard work, computing the Voronoi polygons,
is done by the \code{deldir::deldir} and \code{deldir::tile.list} functions. 
See documentation for those functions for details of computations.

This function is convenient because it takes a \code{SpatialPoints*} 
object and returns a \code{SpatialPolygonsDataFrame} object.
}
\examples{

# Triangular grid inside a set of polygons
WA.samp <- sss.polygon(WA,100,triangular=TRUE) 

# Voronoi polygons of triangular grid 
WA.tess <- voronoi.polygons(WA.samp)

# Plot 
plot(WA)
plot(WA.tess, add=TRUE, col=rainbow(length(WA.samp)))
plot(WA.samp, add=TRUE, pch=16)

# One way to measure spatial balance: 
# Compare variance of Voronoi polygons to same sized 
# SRS sample.  
WA.bas <- bas.polygon(WA, 100)
WA.srs <- srs.polygon(WA, 100)
WA.bas.tess <- voronoi.polygons(WA.bas)
WA.srs.tess <- voronoi.polygons(WA.srs)
rel.balance <- var(WA.bas.tess$area)/var(WA.srs.tess$area)

}

