% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareSWD.R
\name{prepareSWD}
\alias{prepareSWD}
\title{Prepare an SWD object}
\usage{
prepareSWD(species, p = NULL, a = NULL, coords = NULL, env,
  categorical = NULL)
}
\arguments{
\item{species}{character. The name of the species.}

\item{p}{data.frame. The coordinates of the presence locations.}

\item{a}{data.frame. The coordinates of the absence/background locations.}

\item{coords}{Deprecated.}

\item{env}{\code{\link[raster]{stack}} containing the environmental variables
used to extract the values at coordinate locations.}

\item{categorical}{vector indicating which of the environmental variable are
categorical, default is \code{NULL}.}
}
\value{
An \code{\linkS4class{SWD}} object.
}
\description{
Given the coordinates, the species' name and the environmental variables,
the function creates an \code{\linkS4class{SWD}} object (sample with data).
}
\details{
The \code{\linkS4class{SWD}} object is created in a way that the
presence locations are always before than the absence/background locations.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create the SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")
data
}
\author{
Sergio Vignali
}
