% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainValTest.R
\name{trainValTest}
\alias{trainValTest}
\title{Train, Validation and Test datasets}
\usage{
trainValTest(x, test, val = 0, seed = NULL)
}
\arguments{
\item{x}{\linkS4class{SWD} object containing the data that have to be split
in training, validation and testing datasets.}

\item{test}{numeric. The percentage of data withhold for testing.}

\item{val}{numeric. The percentage of data withhold for validation, default
is 0.}

\item{seed}{numeric. The value used to set the seed in order to have
consistent results, default is \code{NULL}.}
}
\value{
A list with the training, validation and testing data sets or
training and testing data sets accordingly.
}
\description{
Split a dataset randomly in training and testing datasets or training,
validation and testing datasets.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence locations
p_coords <- condor[, 1:2]

# Create SWD object
presence <- prepareSWD(species = "Vultur gryphus", coords = p_coords,
                       env = predictors, categorical = "biome")

# Split presence locations in training (70\%) and testing (30\%) datasets
datasets <- trainValTest(presence, test = 0.3)
train <- datasets[[1]]
test <- datasets[[2]]

# Split presence locations in training (60\%), validation (20\%) and testing
# (20\%) datasets
datasets <- trainValTest(presence, val = 0.2, test = 0.2)
train <- datasets[[1]]
val <- datasets[[2]]
test <- datasets[[3]]
}
\author{
Sergio Vignali
}
