% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_functions.R
\name{SDAContinuousPred}
\alias{SDAContinuousPred}
\title{SDAContinuousPred function}
\usage{
SDAContinuousPred(para_est, cellsize, control.mcmc = NULL,
  pred.loc = NULL, divisor = 1, plot.correlogram = F,
  messages = TRUE, parallel = FALSE)
}
\arguments{
\item{para_est}{an object of class "SDALGCP" obtained as a result of a call to \code{\link{SDALGCPMCML}}.}

\item{cellsize}{the size of the computational grid}

\item{control.mcmc}{output from \code{\link{controlmcmcSDA}}, if not provided, it uses the values used for the parameter estimation}

\item{pred.loc}{optional, the dataframe of the predictive grid.}

\item{divisor}{optional, the value to use to convert the dimension of the polygon, default is 1 which implies no conversion}

\item{plot.correlogram}{logical; if plot.correlogram=TRUE the autocorrelation plot of the conditional simulations is displayed.}

\item{messages}{logical; if messages=TRUE then status messages are printed on the screen (or output device) while the function is running. Default is messages=TRUE.}

\item{parallel}{to parallelize some part of the function.}
}
\value{
pred.draw: the samples of the prediction

pred: the prediction of the relative risk

predSD: the standard error of the prediction

Pred.loc: The coordinates of the predictive locations
}
\description{
This function performs spatial continuous prediction, fixing the model parameters at the Monte Carlo maximum likelihood estimates of a SDALGCP model.
}
\details{
The function returns the prediction of the relative risk exp(S(x))
}
\author{
Olatunji O. Johnson \email{o.johnson@lancaster.ac.uk}

Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
\keyword{internal}
